/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.Comparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractGMapValueTypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.GMapValueTypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.GSortedMapValueTypeSerialiZer;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparatorBytesImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparatorType;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparatorUserImpl;

public class PageSerdeFlink2KeyImpl<K1, K2, V>
extends PageSerdeFlinkImpl<K1, V>
implements PageSerdeFlink2Key<K1, K2, V> {
    private final TypeSerializer<K2> key2Serde;
    private final GComparator<K2> mapComparator;
    private final AbstractGMapValueTypeSerializer<K2, V> gMapValueTypeSerialiZer;

    public PageSerdeFlink2KeyImpl(TypeSerializer<K1> keySerde, TypeSerializer<K2> key2Serde, TypeSerializer<V> valueSerce, GComparator<K2> mapComparator, boolean checksumEnable) {
        super(keySerde, valueSerce);
        this.key2Serde = key2Serde;
        this.mapComparator = mapComparator;
        this.gMapValueTypeSerialiZer = mapComparator == null ? new GMapValueTypeSerializer<K2, V>(key2Serde, valueSerce, checksumEnable) : new GSortedMapValueTypeSerialiZer<K2, V>(key2Serde, valueSerce, mapComparator, checksumEnable);
    }

    @Override
    public TypeSerializer<K2> getKey2Serde() {
        return this.key2Serde;
    }

    @Override
    public GComparator<K2> getMapComparator() {
        return this.mapComparator;
    }

    @Override
    public AbstractGMapValueTypeSerializer<K2, V> getMapValueTypeSerializer() {
        return this.gMapValueTypeSerialiZer;
    }

    public static <K, MK, MV> PageSerdeFlink2KeyImpl<K, MK, MV> of(TypeSerializer<K> keySerializer, TypeSerializer<MK> mapKeySerializer, TypeSerializer<MV> mapValueSerializer, Comparator<MK> userComparator, GComparatorType gComparatorType, boolean checksumEnable) {
        GComparator<MK> mapComparator = userComparator == null ? null : PageSerdeFlink2KeyImpl.buildGComparator(userComparator, gComparatorType, mapKeySerializer);
        return new PageSerdeFlink2KeyImpl<K, MK, MV>(keySerializer, mapKeySerializer, mapValueSerializer, mapComparator, checksumEnable);
    }

    private static <MK> GComparator<MK> buildGComparator(Comparator<MK> userComparator, GComparatorType gComparatorType, TypeSerializer<MK> mapKeySerializer) {
        switch (gComparatorType) {
            case bytes: {
                return new GComparatorBytesImpl<MK>(userComparator, mapKeySerializer);
            }
            case user: {
                return new GComparatorUserImpl<MK>(userComparator, mapKeySerializer);
            }
        }
        throw new GeminiRuntimeException("invalid GComparatorType:" + (Object)((Object)gComparatorType));
    }
}

