/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

public enum PageStatus {
    Init(1),
    Normal(2),
    Flushing(3),
    Flushed(4),
    Fetching(5),
    Fetched(6),
    Compacting(7);

    private final byte code;

    private PageStatus(byte c) {
        this.code = c;
    }

    public byte getCode() {
        return this.code;
    }

    public static PageStatus valueOf(byte status) {
        switch (status) {
            case 1: {
                return Init;
            }
            case 2: {
                return Normal;
            }
            case 3: {
                return Flushing;
            }
            case 4: {
                return Flushed;
            }
            case 5: {
                return Fetching;
            }
            case 6: {
                return Fetched;
            }
            case 7: {
                return Compacting;
            }
        }
        throw new GeminiRuntimeException("Error PageStatus:" + status);
    }

    public boolean canCompaction() {
        return this != Compacting;
    }

    public boolean canFlush() {
        return this != Flushing || this != Compacting;
    }
}

