/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiShutDownException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractHashPageStore;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKList;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKList;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageStoreHashKListImpl<K, E>
extends AbstractHashPageStore<K, List<GSValue<E>>>
implements PageStoreKList<K, E> {
    private static final Logger LOG = LoggerFactory.getLogger(PageStoreHashKListImpl.class);
    protected PageSerdeFlinkListImpl<K, E> pageSerdeFlinkListImpl;

    public PageStoreHashKListImpl(GRegion gRegion, EventExecutor eventExecutor) {
        super(gRegion, eventExecutor);
        this.pageSerdeFlinkListImpl = (PageSerdeFlinkListImpl)this.gRegionContext.getPageSerdeFlink();
    }

    public PageStoreHashKListImpl(GRegion gRegion, PageIndex pageIndex, EventExecutor eventExecutor) {
        super(gRegion, pageIndex, eventExecutor);
        this.pageSerdeFlinkListImpl = (PageSerdeFlinkListImpl)this.gRegionContext.getPageSerdeFlink();
    }

    @Override
    public boolean contains(K key) {
        Object result = this.get((Object)key);
        return this.get((Object)key) != null && !result.isEmpty();
    }

    @Override
    long getRequestCount(List<Tuple2<K, GSValue<List<GSValue<E>>>>> dataSet) {
        return dataSet.stream().map(value -> ((GSValue)value.f1).getRequestCount()).reduce(0, (a, b) -> a + b).intValue();
    }

    @Override
    DataPage doCreateDataPage(long version, List<Tuple2<K, GSValue<List<GSValue<E>>>>> dataSet, int logicPageId) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.of(DataPage.DataPageType.KList, dataSet, this.pageSerdeFlink.getKeySerde(), this.pageSerdeFlinkListImpl.getgListValueTypeSerializer(), version, logicPageId, this.gContext.getSupervisor().getAllocator(), 1L, this.gRegionContext.getGContext().getInPageGCompressAlgorithm());
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKListImpl(gBinaryHashMap, this.pageSerdeFlinkListImpl.getValueSerde(), this.pageSerdeFlinkListImpl.getgListValueTypeSerializer());
    }

    @Override
    public List<GSValue<E>> get(K key) {
        PageIndexContext pageIndexContext = this.pageIndex.getPageIndexContext(key, false);
        LogicChainedPage logicPageID = pageIndexContext.getPageID();
        if (this.isNullPage(logicPageID)) {
            return null;
        }
        List<GSValue<GSValue<E>>> finalResult = null;
        ArrayList<BinaryValue> binaryValueReversedOrderList = new ArrayList<BinaryValue>();
        HashMap<Integer, DataPage> fetchedDataPageMap = new HashMap<Integer, DataPage>();
        for (int curIndex = logicPageID.getCurrentPageChainIndex(); curIndex >= 0 && this.gContext.isDBNormal(); --curIndex) {
            DataPage dataPage = this.getDataPageAutoLoadIfNeed(logicPageID, curIndex, fetchedDataPageMap);
            Preconditions.checkArgument((boolean)(dataPage instanceof DataPageKList), (Object)"Interal BUG, error page");
            logicPageID.getPageAddress(curIndex).addRequestCount(1);
            this.gRegionContext.getPageStoreStats().addPageRequestCount(1L);
            BinaryValue binaryValue = dataPage.getBinaryValue(key);
            dataPage.delReferenceCount(ReferenceCount.ReleaseType.Normal);
            if (binaryValue == null) continue;
            if (binaryValue.getgValueType() == GValueType.Delete) break;
            binaryValueReversedOrderList.add(binaryValue);
            if (binaryValue.getgValueType() == GValueType.PutList) break;
        }
        if (!this.gContext.isDBNormal()) {
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        finalResult = binaryValueReversedOrderList.size() == 0 ? null : this.doCompactValueToPOJO(binaryValueReversedOrderList);
        this.tryLaunchCompactionByRead(pageIndexContext, logicPageID, fetchedDataPageMap);
        return finalResult;
    }

    protected List<GSValue<E>> doCompactValueToPOJO(List<BinaryValue> binaryValueReversedOrderList) {
        try {
            ArrayList<GSValue<E>> result = new ArrayList<GSValue<E>>();
            int index = binaryValueReversedOrderList.size() - 1;
            while (index >= 0) {
                BinaryValue binaryValue = binaryValueReversedOrderList.get(index);
                ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
                Object gsValueList = this.pageSerdeFlinkListImpl.getgListValueTypeSerializer().deserialize(byteBufferDataInputView);
                if (gsValueList == null) continue;
                result.addAll((Collection<GSValue<E>>)gsValueList);
                --index;
            }
            return result;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public void getAll(Map<K, GSValue<List<GSValue<E>>>> container) {
    }

    @Override
    public DataPage doCompactPage(boolean isMajor, List<DataPage> canCompactPageListReversedOrder, long version, int logicPageId) {
        if (canCompactPageListReversedOrder == null || canCompactPageListReversedOrder.size() == 0) {
            throw new GeminiRuntimeException("Interal BUG");
        }
        return this.doCompactPageForStructureValue(isMajor, canCompactPageListReversedOrder, version, logicPageId);
    }

    @Override
    protected DataPage doBuildDataPageFromGBinaryMap(boolean isMajor, long version, int logicPageId, TypeSerializer<K> keySerde, Map<BinaryKey, BinaryValue> finalCompactedMap, long compactionCount) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.ofBinaryList(DataPage.DataPageType.KList, isMajor, version, logicPageId, this.pageSerdeFlink.getKeySerde(), this.gContext.getSupervisor().getAllocator(), finalCompactedMap, compactionCount, this.gContext.getStateFilter(), this.gRegionContext);
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKListImpl(gBinaryHashMap, this.pageSerdeFlinkListImpl.getValueSerde(), this.pageSerdeFlinkListImpl.getgListValueTypeSerializer());
    }

    @Override
    BinaryValue doCompactValue(List<BinaryValue> binaryValueList, boolean isMajor, long version, int logicPageId) {
        return DataPageKListImpl.doCompactionKListValue(binaryValueList, this.pageSerdeFlink.getValueSerde(), isMajor, version, logicPageId, this.gContext.getSupervisor().getDefaultAllocator());
    }
}

