/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiShutDownException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractHashPageStore;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMap;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2KeyImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageStoreHashKMapImpl<K, MK, MV>
extends AbstractHashPageStore<K, Map<MK, GSValue<MV>>>
implements PageStoreKMap<K, MK, MV> {
    private static final Logger LOG = LoggerFactory.getLogger(PageStoreHashKMapImpl.class);
    protected final PageSerdeFlink2Key<K, MK, MV> pageSerdeFlink2Key;

    public PageStoreHashKMapImpl(GRegion gRegion, EventExecutor eventExecutor) {
        super(gRegion, eventExecutor);
        this.pageSerdeFlink2Key = (PageSerdeFlink2KeyImpl)this.gRegionContext.getPageSerdeFlink();
    }

    public PageStoreHashKMapImpl(GRegion gRegion, PageIndex pageIndex, EventExecutor eventExecutor) {
        super(gRegion, pageIndex, eventExecutor);
        this.pageSerdeFlink2Key = (PageSerdeFlink2KeyImpl)this.gRegionContext.getPageSerdeFlink();
    }

    @Override
    public boolean contains(K key) {
        Object result = this.get((Object)key);
        return this.get((Object)key) != null && !result.isEmpty();
    }

    @Override
    long getRequestCount(List<Tuple2<K, GSValue<Map<MK, GSValue<MV>>>>> dataSet) {
        return dataSet.stream().map(value -> ((GSValue)value.f1).getRequestCount()).reduce(0, (a, b) -> a + b).intValue();
    }

    @Override
    DataPage doCreateDataPage(long version, List<Tuple2<K, GSValue<Map<MK, GSValue<MV>>>>> dataSet, int logicPageId) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.of(DataPage.DataPageType.KHashMap, dataSet, this.pageSerdeFlink.getKeySerde(), this.pageSerdeFlink2Key.getMapValueTypeSerializer(), version, logicPageId, this.gContext.getSupervisor().getAllocator(), 1L, this.gRegionContext.getGContext().getInPageGCompressAlgorithm());
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKMapImpl(gBinaryHashMap, this.pageSerdeFlink2Key.getKey2Serde(), this.pageSerdeFlink2Key.getValueSerde(), this.pageSerdeFlink2Key.getMapValueTypeSerializer());
    }

    @Override
    public Map<MK, GSValue<MV>> get(K key) {
        PageIndexContext pageIndexContext = this.pageIndex.getPageIndexContext(key, false);
        LogicChainedPage logicPageID = pageIndexContext.getPageID();
        if (this.isNullPage(logicPageID)) {
            return null;
        }
        Map<MK, GSValue<MV>> finalResult = null;
        ArrayList<BinaryValue> binaryValueReversedOrderList = new ArrayList<BinaryValue>();
        HashMap<Integer, DataPage> fetchedDataPageMap = new HashMap<Integer, DataPage>();
        for (int curIndex = logicPageID.getCurrentPageChainIndex(); curIndex >= 0 && this.gContext.isDBNormal(); --curIndex) {
            DataPage dataPage = this.getDataPageAutoLoadIfNeed(logicPageID, curIndex, fetchedDataPageMap);
            Preconditions.checkArgument((boolean)(dataPage instanceof DataPageKMap), (Object)"Interal BUG, error page");
            logicPageID.getPageAddress(curIndex).addRequestCount(1);
            this.gRegionContext.getPageStoreStats().addPageRequestCount(1L);
            BinaryValue binaryValue = dataPage.getBinaryValue(key);
            dataPage.delReferenceCount(ReferenceCount.ReleaseType.Normal);
            if (binaryValue == null) continue;
            if (binaryValue.getgValueType() == GValueType.Delete) break;
            binaryValueReversedOrderList.add(binaryValue);
            if (binaryValue.getgValueType() == GValueType.PutMap) break;
        }
        if (!this.gContext.isDBNormal()) {
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        finalResult = binaryValueReversedOrderList.size() == 0 ? null : this.doCompactValueToPOJO(binaryValueReversedOrderList);
        this.tryLaunchCompactionByRead(pageIndexContext, logicPageID, fetchedDataPageMap);
        return finalResult;
    }

    @Override
    public MV get(K key, MK mapKey) {
        int curIndex;
        PageIndexContext pageIndexContext = this.pageIndex.getPageIndexContext(key, false);
        LogicChainedPage logicPageID = pageIndexContext.getPageID();
        if (this.isNullPage(logicPageID)) {
            return null;
        }
        MV finalResult = null;
        HashMap<Integer, DataPage> fetchedDataPageMap = new HashMap<Integer, DataPage>(curIndex);
        for (curIndex = logicPageID.getCurrentPageChainIndex(); curIndex >= 0 && this.gContext.isDBNormal(); --curIndex) {
            DataPage dataPage = this.getDataPageAutoLoadIfNeed(logicPageID, curIndex, fetchedDataPageMap);
            Preconditions.checkArgument((boolean)(dataPage instanceof DataPageKMap), (Object)"Interal BUG, error page");
            logicPageID.getPageAddress(curIndex).addRequestCount(1);
            this.gRegionContext.getPageStoreStats().addPageRequestCount(1L);
            GSValue result = ((DataPageKMap)dataPage).get(key, mapKey);
            dataPage.delReferenceCount(ReferenceCount.ReleaseType.Normal);
            if (result == null) continue;
            if (result.getValueType() == GValueType.Delete || this.gRegionContext.filterState(result.getSeqID())) break;
            finalResult = result.getValue();
            break;
        }
        if (!this.gContext.isDBNormal()) {
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        this.tryLaunchCompactionByRead(pageIndexContext, logicPageID, fetchedDataPageMap);
        return finalResult;
    }

    @Override
    public void getAll(Map<K, GSValue<Map<MK, GSValue<MV>>>> container) {
    }

    @Override
    public boolean contains(K key, MK mapKey) {
        return this.get(key, mapKey) != null;
    }

    @Override
    public DataPage doCompactPage(boolean isMajor, List<DataPage> canCompactPageListReversedOrder, long version, int logicPageId) {
        if (canCompactPageListReversedOrder == null || canCompactPageListReversedOrder.size() == 0) {
            throw new GeminiRuntimeException("Interal BUG");
        }
        return this.doCompactPageForStructureValue(isMajor, canCompactPageListReversedOrder, version, logicPageId);
    }

    @Override
    BinaryValue doCompactValue(List<BinaryValue> binaryValueList, boolean isMajor, long version, int logicPageId) {
        return DataPageKMapImpl.doCompactionMapValue(binaryValueList, this.pageSerdeFlink2Key.getKey2Serde(), this.pageSerdeFlink2Key.getValueSerde(), isMajor, version, logicPageId, this.gContext.getSupervisor().getDefaultAllocator(), this.gContext.getStateFilter(), this.gRegionContext);
    }

    Map<MK, GSValue<MV>> doCompactValueToPOJO(List<BinaryValue> binaryValueReversedOrderList) {
        Map<BinaryKey, BinaryValue> binaryValueMap = DataPageKMapImpl.doCompactValueToBinaryMap(binaryValueReversedOrderList, this.pageSerdeFlink2Key.getKey2Serde());
        HashMap<MK, GSValue<MV>> result = new HashMap<MK, GSValue<MV>>(binaryValueMap.size());
        for (Map.Entry<BinaryKey, BinaryValue> entry : binaryValueMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().getgValueType() == GValueType.Delete) continue;
            result.put(this.getMKeyFromBinary(entry.getKey()), this.getMValueFromBinary(entry.getValue()));
        }
        return result;
    }

    protected GSValue<MV> getMValueFromBinary(BinaryValue binaryValue) {
        if (binaryValue == null) {
            return null;
        }
        if (binaryValue.getgValueType() == GValueType.Delete) {
            return new GSValue<Object>(null, GValueType.Delete, binaryValue.getSeqID());
        }
        try {
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
            Object value = this.pageSerdeFlink2Key.getValueSerde().deserialize((DataInputView)byteBufferDataInputView);
            return new GSValue<Object>(value, binaryValue.getgValueType(), binaryValue.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Exception: " + e.getMessage(), e);
        }
    }

    protected MK getMKeyFromBinary(BinaryKey key) {
        if (key == null) {
            throw new GeminiRuntimeException("key can't be null");
        }
        try {
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(key.getBb(), key.getKeyOffset(), key.getKeyLen());
            return (MK)this.pageSerdeFlink2Key.getKey2Serde().deserialize((DataInputView)byteBufferDataInputView);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Exception: " + e.getMessage(), e);
        }
    }

    @Override
    protected DataPage doBuildDataPageFromGBinaryMap(boolean isMajor, long version, int logicPageId, TypeSerializer<K> keySerde, Map<BinaryKey, BinaryValue> finalCompactedMap, long compactionCount) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.ofBinaryList(DataPage.DataPageType.KHashMap, isMajor, version, logicPageId, this.pageSerdeFlink.getKeySerde(), this.gContext.getSupervisor().getAllocator(), finalCompactedMap, compactionCount, this.gContext.getStateFilter(), this.gRegionContext);
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKMapImpl(gBinaryHashMap, this.pageSerdeFlink2Key.getKey2Serde(), this.pageSerdeFlink2Key.getValueSerde(), this.pageSerdeFlink2Key.getMapValueTypeSerializer());
    }
}

