/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKSortedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreHashKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKSortedMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageStoreHashKSortedMapImpl<K, MK, MV>
extends PageStoreHashKMapImpl<K, MK, MV>
implements PageStoreKSortedMap<K, MK, MV> {
    private static final Logger LOG = LoggerFactory.getLogger(PageStoreHashKSortedMapImpl.class);

    public PageStoreHashKSortedMapImpl(GRegion gRegion, EventExecutor eventExecutor) {
        super(gRegion, eventExecutor);
    }

    public PageStoreHashKSortedMapImpl(GRegion gRegion, PageIndex pageIndex, EventExecutor eventExecutor) {
        super(gRegion, pageIndex, eventExecutor);
    }

    @Override
    DataPage doCreateDataPage(long version, List<Tuple2<K, GSValue<Map<MK, GSValue<MV>>>>> dataSet, int logicPageId) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.of(DataPage.DataPageType.KSortedMap, dataSet, this.pageSerdeFlink.getKeySerde(), this.pageSerdeFlink2Key.getMapValueTypeSerializer(), version, logicPageId, this.gContext.getSupervisor().getAllocator(), 1L, this.gRegionContext.getGContext().getInPageGCompressAlgorithm());
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKSortedMapImpl(gBinaryHashMap, this.pageSerdeFlink2Key.getKey2Serde(), this.pageSerdeFlink2Key.getValueSerde(), this.pageSerdeFlink2Key.getMapValueTypeSerializer(), this.pageSerdeFlink2Key.getMapComparator());
    }

    @Override
    public TreeMap<MK, GSValue<MV>> get(K key) {
        Object result = super.get((Object)key);
        if (result != null) {
            Preconditions.checkArgument((boolean)(result instanceof TreeMap), (Object)"Interal Bug");
            return (TreeMap)result;
        }
        return null;
    }

    @Override
    TreeMap<MK, GSValue<MV>> doCompactValueToPOJO(List<BinaryValue> binaryValueReversedOrderList) {
        Map<BinaryKey, BinaryValue> binaryValueMap = DataPageKMapImpl.doCompactValueToBinaryMap(binaryValueReversedOrderList, this.pageSerdeFlink2Key.getKey2Serde());
        TreeMap result = new TreeMap(this.pageSerdeFlink2Key.getMapComparator().getJDKCompactor());
        for (Map.Entry<BinaryKey, BinaryValue> entry : binaryValueMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().getgValueType() == GValueType.Delete) continue;
            result.put(this.getMKeyFromBinary(entry.getKey()), this.getMValueFromBinary(entry.getValue()));
        }
        return result;
    }

    @Override
    protected DataPage doBuildDataPageFromGBinaryMap(boolean isMajor, long version, int logicPageId, TypeSerializer<K> keySerde, Map<BinaryKey, BinaryValue> finalCompactedMap, long compactionCount) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.ofBinaryList(DataPage.DataPageType.KSortedMap, isMajor, version, logicPageId, this.pageSerdeFlink.getKeySerde(), this.gContext.getSupervisor().getAllocator(), finalCompactedMap, compactionCount, this.gContext.getStateFilter(), this.gRegionContext);
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKSortedMapImpl(gBinaryHashMap, this.pageSerdeFlink2Key.getKey2Serde(), this.pageSerdeFlink2Key.getValueSerde(), this.pageSerdeFlink2Key.getMapValueTypeSerializer(), this.pageSerdeFlink2Key.getMapComparator());
    }

    @Override
    BinaryValue doCompactValue(List<BinaryValue> binaryValueList, boolean isMajor, long version, int logicPageId) {
        return DataPageKSortedMapImpl.doCompactionSortedMapValue(binaryValueList, this.pageSerdeFlink2Key.getKey2Serde(), this.pageSerdeFlink2Key.getMapComparator(), isMajor, version, logicPageId, this.gContext.getSupervisor().getDefaultAllocator(), this.gContext.getStateFilter(), this.gRegionContext);
    }

    @Override
    public Map.Entry<MK, MV> firstEntry(K key) {
        Map sortedMap = this.get((Object)key);
        if (sortedMap == null) {
            return null;
        }
        final Map.Entry firstEntry = ((TreeMap)sortedMap).firstEntry();
        return new Map.Entry<MK, MV>(){

            @Override
            public MK getKey() {
                return firstEntry.getKey();
            }

            @Override
            public MV getValue() {
                return ((GSValue)firstEntry.getValue()).getValue();
            }

            @Override
            public MV setValue(MV value) {
                return null;
            }
        };
    }

    @Override
    public Map.Entry<MK, MV> lastEntry(K key) {
        Map sortedMap = this.get((Object)key);
        if (sortedMap == null) {
            return null;
        }
        final Map.Entry lastEntry = ((TreeMap)sortedMap).lastEntry();
        return new Map.Entry<MK, MV>(){

            @Override
            public MK getKey() {
                return lastEntry.getKey();
            }

            @Override
            public MV getValue() {
                return ((GSValue)lastEntry.getValue()).getValue();
            }

            @Override
            public MV setValue(MV value) {
                return null;
            }
        };
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> headIterator(K key, MK endMapKey) {
        SortedMap submap;
        Map sortedMap = this.get((Object)key);
        if (sortedMap == null) {
            Collections.emptyIterator();
        }
        if ((submap = ((TreeMap)sortedMap).headMap(endMapKey)) == null || submap.size() == 0) {
            Collections.emptyIterator();
        }
        return Maps.transformEntries(submap, (mk, mv) -> mv.getValue()).entrySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> tailIterator(K key, MK startMapKey) {
        SortedMap submap;
        Map sortedMap = this.get((Object)key);
        if (sortedMap == null) {
            Collections.emptyIterator();
        }
        if ((submap = ((TreeMap)sortedMap).tailMap(startMapKey)) == null || submap.size() == 0) {
            Collections.emptyIterator();
        }
        return Maps.transformEntries(submap, (mk, mv) -> mv.getValue()).entrySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> subIterator(K key, MK startMapKey, MK endMapKey) {
        SortedMap submap;
        Map sortedMap = this.get((Object)key);
        if (sortedMap == null) {
            Collections.emptyIterator();
        }
        if ((submap = ((TreeMap)sortedMap).subMap(startMapKey, endMapKey)) == null || submap.size() == 0) {
            Collections.emptyIterator();
        }
        return Maps.transformEntries(submap, (mk, mv) -> mv.getValue()).entrySet().iterator();
    }
}

