/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiShutDownException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractHashPageStore;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKVImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageStoreHashKVImpl<K, V>
extends AbstractHashPageStore<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(PageStoreHashKVImpl.class);

    public PageStoreHashKVImpl(GRegion gRegion, EventExecutor eventExecutor) {
        super(gRegion, eventExecutor);
    }

    public PageStoreHashKVImpl(GRegion gRegion, PageIndex pageIndex, EventExecutor eventExecutor) {
        super(gRegion, pageIndex, eventExecutor);
    }

    @Override
    public V get(K key) {
        PageIndexContext pageIndexContext = this.pageIndex.getPageIndexContext(key, false);
        LogicChainedPage logicPageID = pageIndexContext.getPageID();
        if (this.isNullPage(logicPageID)) {
            return null;
        }
        V finalResult = null;
        HashMap<Integer, DataPage> fetchedDataPageMap = new HashMap<Integer, DataPage>();
        for (int curIndex = logicPageID.getCurrentPageChainIndex(); curIndex >= 0 && this.gContext.isDBNormal(); --curIndex) {
            DataPage dataPage = this.getDataPageAutoLoadIfNeed(logicPageID, curIndex, fetchedDataPageMap);
            logicPageID.getPageAddress(curIndex).addRequestCount(1);
            this.gRegionContext.getPageStoreStats().addPageRequestCount(1L);
            GSValue result = dataPage.get(key);
            dataPage.delReferenceCount(ReferenceCount.ReleaseType.Normal);
            if (result == null) continue;
            if (result.getValueType() == GValueType.Delete || this.gRegionContext.filterState(result.getSeqID())) break;
            finalResult = result.getValue();
            break;
        }
        if (!this.gContext.isDBNormal()) {
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        this.tryLaunchCompactionByRead(pageIndexContext, logicPageID, fetchedDataPageMap);
        return finalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAll(Map<K, GSValue<V>> container) {
        LogicChainedPage[] chains;
        for (LogicChainedPage logicChainedPage : chains = this.pageIndex.getPageIndex()) {
            int numPages;
            if (this.isNullPage(logicChainedPage)) continue;
            for (int i = numPages = logicChainedPage.getCurrentPageChainIndex(); i >= 0; --i) {
                PageAddress pageAddress = logicChainedPage.getPageAddress(i);
                DataPage dataPage = pageAddress.getDataPage();
                try {
                    if (dataPage == null) {
                        this.cacheManager.getCacheStats().addPageCacheMissCount();
                        dataPage = this.gContext.getSupervisor().getFetchPolicy().fetch(pageAddress, logicChainedPage, i, this.gRegionContext, this.gRegionContext.getGContext().getGConfiguration().getEnablePrefetch(), false);
                    } else {
                        this.cacheManager.getCacheStats().addPageCacheHitCount();
                    }
                    Map data = dataPage.getPOJOMap();
                    for (Map.Entry entry : data.entrySet()) {
                        if (this.gRegionContext.filterState(entry.getValue().getSeqID())) continue;
                        container.putIfAbsent(entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                finally {
                    if (dataPage != null) {
                        dataPage.delReferenceCount(ReferenceCount.ReleaseType.Normal);
                    }
                }
            }
        }
    }

    @Override
    public DataPage doCompactPage(boolean isMajor, List<DataPage> canCompactPageListReversedOrder, long version, int logicPageId) {
        Map<Object, Object> newMap;
        if (canCompactPageListReversedOrder == null || canCompactPageListReversedOrder.size() == 0) {
            throw new GeminiRuntimeException("Interal BUG");
        }
        ArrayList compactionListReversedOrder = new ArrayList();
        for (DataPage dataPage : canCompactPageListReversedOrder) {
            compactionListReversedOrder.add(dataPage.getGBinaryHashMap());
        }
        int index = compactionListReversedOrder.size() - 1;
        long compactionCount = 0L;
        if (this.gContext.hasTtl()) {
            newMap = new HashMap();
        } else {
            newMap = ((GBinaryHashMap)compactionListReversedOrder.get(index)).getBinaryMap();
            compactionCount += ((GBinaryHashMap)compactionListReversedOrder.get(index)).getCompactionCount();
            --index;
        }
        while (index >= 0) {
            newMap.putAll(((GBinaryHashMap)compactionListReversedOrder.get(index)).getBinaryMap());
            compactionCount += ((GBinaryHashMap)compactionListReversedOrder.get(index)).getCompactionCount();
            --index;
        }
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.ofBinaryList(DataPage.DataPageType.KV, isMajor, version, logicPageId, this.pageSerdeFlink.getKeySerde(), this.gContext.getSupervisor().getAllocator(), newMap, compactionCount, this.gContext.getStateFilter(), this.gRegionContext);
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKVImpl(gBinaryHashMap, this.pageSerdeFlink.getValueSerde());
    }

    @Override
    BinaryValue doCompactValue(List<BinaryValue> binaryValueList, boolean isMajor, long version, int logicPageId) {
        throw new GeminiRuntimeException("Internal Bug");
    }

    @Override
    protected DataPage doBuildDataPageFromGBinaryMap(boolean isMajor, long version, int logicPageId, TypeSerializer<K> keySerde, Map<BinaryKey, BinaryValue> finalCompactedMap, long compactionCount) {
        throw new GeminiRuntimeException("Internal Bug");
    }

    @Override
    long getRequestCount(List<Tuple2<K, GSValue<V>>> dataSet) {
        return dataSet.stream().map(value -> ((GSValue)value.f1).getRequestCount()).reduce(0, (a, b) -> a + b).intValue();
    }

    @Override
    DataPage doCreateDataPage(long version, List<Tuple2<K, GSValue<V>>> dataSet, int logicPageId) {
        GBinaryHashMap<K> gBinaryHashMap = GBinaryHashMap.of(DataPage.DataPageType.KV, dataSet, this.pageSerdeFlink.getKeySerde(), this.pageSerdeFlink.getValueSerde(), version, logicPageId, this.gContext.getSupervisor().getAllocator(), 1L, this.gContext.getInPageGCompressAlgorithm());
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKVImpl(gBinaryHashMap, this.pageSerdeFlink.getValueSerde());
    }
}

