/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.vm.CacheManager;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;

public class PageStoreStats {
    private final CacheManager cacheManager;
    private int indexCapacity = 0;
    private volatile float pageSizeRate;
    private final AtomicInteger logicPageCount = new AtomicInteger(0);
    private final AtomicLong pageUsedMemory = new AtomicLong(0L);
    private final AtomicLong logicPageSize = new AtomicLong(0L);
    private final AtomicLong logicPageChainCapacity = new AtomicLong(0L);
    private final AtomicLong logicPageChainLen = new AtomicLong(0L);
    private final AtomicLong pageRequestCount = new AtomicLong(0L);
    private volatile float evictedRate = 0.0f;
    private final AtomicLong addPages = new AtomicLong(0L);
    private final AtomicLong minorCompactions = new AtomicLong(0L);
    private final AtomicLong minorCompactedPages = new AtomicLong(0L);
    private final AtomicLong majorCompactions = new AtomicLong(0L);
    private final AtomicLong majorCompactedPages = new AtomicLong(0L);
    private final AtomicInteger runningMinorCompaction = new AtomicInteger(0);
    private final AtomicInteger runningMajorCompaction = new AtomicInteger(0);
    private final AtomicInteger runningMinorCompactionByRead = new AtomicInteger(0);
    private final String name;
    private EventExecutor regionEventExecutor;

    public PageStoreStats(String name, CacheManager cacheManager) {
        this.name = name;
        this.cacheManager = cacheManager;
    }

    public int getIndexCapacity() {
        return this.indexCapacity;
    }

    public float getPageSizeRate() {
        return this.pageSizeRate;
    }

    public int getLogicPageCount() {
        return this.logicPageCount.get();
    }

    public long getLogicPageSize() {
        return this.logicPageSize.get();
    }

    public void setIndexCapacity(int indexCapacity) {
        this.cacheManager.addIndexCapacity(-this.indexCapacity);
        this.indexCapacity = indexCapacity;
        this.cacheManager.addIndexCapacity(this.indexCapacity);
    }

    public void setPageSizeRate(float pageSizeRate) {
        this.pageSizeRate = pageSizeRate;
    }

    public void addLogicPageCount(int logicPageCount) {
        this.logicPageCount.addAndGet(logicPageCount);
        this.cacheManager.getCacheStats().addTotalLogicPageCount(logicPageCount);
    }

    public void addLogicPageSize(int logicPageSize) {
        this.logicPageSize.addAndGet(logicPageSize);
        this.cacheManager.getCacheStats().addTotalLogicPageSize(logicPageSize);
    }

    public void addPageUsedMemory(GRegion gRegion, int logicPageSize) {
        this.addPageUsedMemory(gRegion, logicPageSize, true);
    }

    public void addPageUsedMemory(GRegion gRegion, int logicPageSize, boolean needEvict) {
        this.pageUsedMemory.addAndGet(logicPageSize);
        this.cacheManager.getCacheStats().addPageUsedMemory(logicPageSize);
        this.cacheManager.getEvictPolicy().addPageUsedMemory(gRegion, this.regionEventExecutor, logicPageSize, needEvict);
    }

    public void addLogicPageChainCapacity(int logicPageChainLen) {
        this.logicPageChainCapacity.addAndGet(logicPageChainLen);
    }

    public void addLogicPageChainLen(int logicPageChainLen) {
        this.logicPageChainLen.addAndGet(logicPageChainLen);
        this.cacheManager.getCacheStats().addTotalLogicPageChainLen(logicPageChainLen);
    }

    public void addPageRequestCount(long pageRequest) {
        this.pageRequestCount.addAndGet(pageRequest);
    }

    public void addPage() {
        this.addPages.addAndGet(1L);
    }

    public void addMinorCompactedPages(int n) {
        this.minorCompactions.addAndGet(1L);
        this.minorCompactedPages.addAndGet(n);
        this.cacheManager.getCacheStats().addMinorCompactedPages(n);
    }

    public void addMajorCompactedPages(int n) {
        this.majorCompactions.addAndGet(1L);
        this.majorCompactedPages.addAndGet(n);
        this.cacheManager.getCacheStats().addMajorCompactedPages(n);
    }

    public void addRuningMajorCompactedPages(int i) {
        this.runningMajorCompaction.addAndGet(i);
        this.cacheManager.getCacheStats().addTotalRuningMajorCompactedPages(i);
    }

    public void addRuningMinorCompactedPages(int i) {
        this.runningMinorCompaction.addAndGet(i);
        this.cacheManager.getCacheStats().addTotalRuningMinorCompactedPages(i);
    }

    public void addRuningMinorCompactionByRead(int i) {
        this.runningMinorCompactionByRead.addAndGet(i);
        this.cacheManager.getCacheStats().addRuningMinorCompactionByRead(i);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("indexCapacity", this.indexCapacity).add("pageSizeRate", this.pageSizeRate).add("logicPageCount", this.logicPageCount.get()).add("pageUsedMemory", this.pageUsedMemory.get()).add("logicPageSize", this.logicPageSize.get()).add("logicPageChainLen", this.logicPageChainLen.get()).add("logicPageChainCapacity", this.logicPageChainCapacity.get()).add("pageRequestCount", this.pageRequestCount.get()).add("evictedRate", this.evictedRate).add("addPages", this.addPages.get()).add("minorCompactions", this.minorCompactions.get()).add("minorCompactedPages", this.minorCompactedPages.get()).add("majorCompactions", this.majorCompactions.get()).add("majorCompactedPages", this.majorCompactedPages.get()).add("runningMajorCompaction", this.runningMajorCompaction.get()).add("runningMinorCompaction", this.runningMinorCompaction.get()).add("runningMinorCompactionByRead", this.runningMinorCompactionByRead.get());
        if (this.minorCompactions.get() > 0L) {
            helper.add("avgSyncCompactedPages", (double)this.minorCompactedPages.get() / (double)this.minorCompactions.get());
        }
        return helper.toString();
    }

    public void setRegionExecutor(EventExecutor regionEventExecutor) {
        this.regionEventExecutor = regionEventExecutor;
    }
}

