/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;

public final class BinaryKey {
    private final int keyOffset;
    private final int keyLen;
    private final int keyhashCode;
    private final ByteBuffer bb;

    public BinaryKey(ByteBuffer data, int keyOffset, int keyLen, int keyhashCode) {
        this.keyOffset = keyOffset;
        this.keyLen = keyLen;
        this.bb = data;
        this.keyhashCode = keyhashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryKey binaryKey = (BinaryKey)o;
        return this.keyhashCode == binaryKey.keyhashCode && this.keyLen == binaryKey.keyLen && ByteBufferUtils.compareTo(this.bb, this.keyOffset, this.keyLen, binaryKey.bb, binaryKey.keyOffset, binaryKey.keyLen) == 0;
    }

    public int hashCode() {
        return this.keyhashCode;
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }

    public int getKeyLen() {
        return this.keyLen;
    }

    public int getKeyhashCode() {
        return this.keyhashCode;
    }

    public ByteBuffer getBb() {
        return this.bb;
    }
}

