/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class ByteBufferDataInputView
implements DataInputView {
    protected ByteBuffer buffer;
    protected int position;
    protected int count;
    protected int mark = 0;
    private char[] lineBuffer;

    public ByteBufferDataInputView(ByteBuffer buffer, int offset, int length) {
        this.position = offset;
        this.buffer = buffer;
        this.mark = offset;
        this.count = offset + length;
    }

    public int read() {
        return this.position < this.count ? 0xFF & this.buffer.get(this.position++) : -1;
    }

    public void skipBytesToRead(int numBytes) throws IOException {
        if (this.skipBytes(numBytes) != numBytes) {
            throw new EOFException("Could not skip " + numBytes + " bytes.");
        }
    }

    public int read(byte[] b, int off, int len) {
        Preconditions.checkNotNull((Object)b);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.count) {
            return -1;
        }
        int available = this.count - this.position;
        if (len > available) {
            len = available;
        }
        if (len <= 0) {
            return 0;
        }
        ByteBufferUtils.copyFromBufferToArray(this.buffer, b, this.position, off, len);
        this.position += len;
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long toSkip) {
        long remain = this.count - this.position;
        if (toSkip < remain) {
            remain = toSkip < 0L ? 0L : toSkip;
        }
        this.position = (int)((long)this.position + remain);
        return remain;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    public void reset() {
        this.position = this.mark;
    }

    public int available() {
        return this.count - this.position;
    }

    public void close() throws IOException {
    }

    public long getPos() {
        return this.position;
    }

    public void seek(long pos) {
        Preconditions.checkArgument((pos >= 0L && pos <= (long)this.count ? 1 : 0) != 0, (Object)"Position out of bounds.");
        this.position = (int)pos;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() throws IOException {
        int result = ByteBufferUtils.toInt(this.buffer, this.position);
        this.position += 4;
        return result;
    }

    public long readLong() throws IOException {
        long result = ByteBufferUtils.toLong(this.buffer, this.position);
        this.position += 8;
        return result;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        int c;
        char[] buf = this.lineBuffer;
        if (buf == null) {
            buf = this.lineBuffer = new char[128];
        }
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = this.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    --this.position;
                    break block4;
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(this.lineBuffer, 0, buf, 0, offset);
                        this.lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararrCount = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }
}

