/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.UnsafeHelp;
import sun.nio.ch.DirectBuffer;

public class ByteBufferUtils {
    private static final boolean UNSAFE_AVAIL = UnsafeHelp.isAvailable();
    private static final boolean UNSAFE_UNALIGNED = UnsafeHelp.unaligned();

    public static int toInt(ByteBuffer buffer, int offset) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeHelp.toInt(buffer, offset);
        }
        return buffer.getInt(offset);
    }

    public static long toLong(ByteBuffer buffer, int offset) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeHelp.toLong(buffer, offset);
        }
        return buffer.getLong(offset);
    }

    public static short toShort(ByteBuffer buffer, int offset) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeHelp.toShort(buffer, offset);
        }
        return buffer.getShort(offset);
    }

    public static byte toByte(ByteBuffer buffer, int offset) {
        if (UnsafeHelp.isAvailable()) {
            return UnsafeHelp.toByte(buffer, offset);
        }
        return buffer.get(offset);
    }

    public static void putInt(ByteBuffer buffer, int index, int val) {
        if (UNSAFE_UNALIGNED) {
            UnsafeHelp.putInt(buffer, index, val);
        }
        buffer.putInt(index, val);
    }

    public static void putLong(ByteBuffer buffer, int index, long val) {
        if (UNSAFE_UNALIGNED) {
            UnsafeHelp.putLong(buffer, index, val);
        }
        buffer.putLong(index, val);
    }

    public static void putByte(ByteBuffer buffer, int index, byte val) {
        if (UNSAFE_UNALIGNED) {
            UnsafeHelp.putByte(buffer, index, val);
        }
        buffer.put(index, val);
    }

    public static int copyFromBufferToBuffer(ByteBuffer in, ByteBuffer out, int sourceOffset, int destinationOffset, int length) {
        if (in.hasArray() && out.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out.array(), out.arrayOffset() + destinationOffset, length);
        } else if (UNSAFE_AVAIL) {
            UnsafeHelp.copy(in, sourceOffset, out, destinationOffset, length);
        } else {
            int outOldPos = out.position();
            out.position(destinationOffset);
            ByteBuffer inDup = in.duplicate();
            inDup.position(sourceOffset).limit(sourceOffset + length);
            out.put(inDup);
            out.position(outOldPos);
        }
        return destinationOffset + length;
    }

    public static void copyFromArrayToBuffer(ByteBuffer out, int outOffset, byte[] in, int inOffset, int length) {
        if (out.hasArray()) {
            System.arraycopy(in, inOffset, out.array(), out.arrayOffset() + outOffset, length);
        } else if (UNSAFE_AVAIL) {
            UnsafeHelp.copy(in, inOffset, out, outOffset, length);
        } else {
            int oldPos = out.position();
            out.position(outOffset);
            out.put(in, inOffset, length);
            out.position(oldPos);
        }
    }

    public static void copyFromBufferToArray(ByteBuffer in, byte[] out, int sourceOffset, int destinationOffset, int length) {
        if (in.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out, destinationOffset, length);
        } else if (UNSAFE_AVAIL) {
            UnsafeHelp.copy(in, sourceOffset, out, destinationOffset, length);
        } else {
            int oldPos = in.position();
            in.position(sourceOffset);
            in.get(out, destinationOffset, length);
            in.position(oldPos);
        }
    }

    public static int compareTo(ByteBuffer buf1, int o1, int l1, byte[] buf2, int o2, int l2) {
        if (UNSAFE_UNALIGNED) {
            long offset1Adj;
            byte[] refObj1 = null;
            if (buf1.isDirect()) {
                offset1Adj = (long)o1 + ((DirectBuffer)((Object)buf1)).address();
            } else {
                offset1Adj = (long)(o1 + buf1.arrayOffset()) + UnsafeHelp.BYTE_ARRAY_BASE_OFFSET;
                refObj1 = buf1.array();
            }
            return ByteBufferUtils.compareToUnsafe(refObj1, offset1Adj, l1, buf2, (long)o2 + UnsafeHelp.BYTE_ARRAY_BASE_OFFSET, l2);
        }
        int end1 = o1 + l1;
        int end2 = o2 + l2;
        int i = o1;
        for (int j = o2; i < end1 && j < end2; ++i, ++j) {
            int b;
            int a = buf1.get(i) & 0xFF;
            if (a == (b = buf2[j] & 0xFF)) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static int compareTo(ByteBuffer buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
        if (UNSAFE_UNALIGNED) {
            long offset2Adj;
            long offset1Adj;
            byte[] refObj1 = null;
            byte[] refObj2 = null;
            if (buf1.isDirect()) {
                offset1Adj = (long)o1 + ((DirectBuffer)((Object)buf1)).address();
            } else {
                offset1Adj = (long)(o1 + buf1.arrayOffset()) + UnsafeHelp.BYTE_ARRAY_BASE_OFFSET;
                refObj1 = buf1.array();
            }
            if (buf2.isDirect()) {
                offset2Adj = (long)o2 + ((DirectBuffer)((Object)buf2)).address();
            } else {
                offset2Adj = (long)(o2 + buf2.arrayOffset()) + UnsafeHelp.BYTE_ARRAY_BASE_OFFSET;
                refObj2 = buf2.array();
            }
            return ByteBufferUtils.compareToUnsafe(refObj1, offset1Adj, l1, refObj2, offset2Adj, l2);
        }
        int end1 = o1 + l1;
        int end2 = o2 + l2;
        int i = o1;
        for (int j = o2; i < end1 && j < end2; ++i, ++j) {
            int b;
            int a = buf1.get(i) & 0xFF;
            if (a == (b = buf2.get(j) & 0xFF)) continue;
            return a - b;
        }
        return l1 - l2;
    }

    static int compareToUnsafe(Object obj1, long o1, int l1, Object obj2, long o2, int l2) {
        int b;
        int a;
        int minLength = Math.min(l1, l2);
        int minWords = minLength / 8;
        int j = minWords << 3;
        for (int i = 0; i < j; i += 8) {
            long rw;
            long lw = UnsafeHelp.UNSAFE.getLong(obj1, o1 + (long)i);
            long diff = lw ^ (rw = UnsafeHelp.UNSAFE.getLong(obj2, o2 + (long)i));
            if (diff == 0L) continue;
            return ByteBufferUtils.lessThanUnsignedLong(lw, rw) ? -1 : 1;
        }
        int offset = j;
        if (minLength - offset >= 4) {
            int ir;
            int il = UnsafeHelp.UNSAFE.getInt(obj1, o1 + (long)offset);
            if (il != (ir = UnsafeHelp.UNSAFE.getInt(obj2, o2 + (long)offset))) {
                return ByteBufferUtils.lessThanUnsignedInt(il, ir) ? -1 : 1;
            }
            offset += 4;
        }
        if (minLength - offset >= 2) {
            short sr;
            short sl = UnsafeHelp.UNSAFE.getShort(obj1, o1 + (long)offset);
            if (sl != (sr = UnsafeHelp.UNSAFE.getShort(obj2, o2 + (long)offset))) {
                return ByteBufferUtils.lessThanUnsignedShort(sl, sr) ? -1 : 1;
            }
            offset += 2;
        }
        if (minLength - offset == 1 && (a = UnsafeHelp.UNSAFE.getByte(obj1, o1 + (long)offset) & 0xFF) != (b = UnsafeHelp.UNSAFE.getByte(obj2, o2 + (long)offset) & 0xFF)) {
            return a - b;
        }
        return l1 - l2;
    }

    private static boolean lessThanUnsignedLong(long x1, long x2) {
        if (UnsafeHelp.LITTLE_ENDIAN) {
            x1 = Long.reverseBytes(x1);
            x2 = Long.reverseBytes(x2);
        }
        return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
    }

    private static boolean lessThanUnsignedInt(int x1, int x2) {
        if (UnsafeHelp.LITTLE_ENDIAN) {
            x1 = Integer.reverseBytes(x1);
            x2 = Integer.reverseBytes(x2);
        }
        return ((long)x1 & 0xFFFFFFFFL) < ((long)x2 & 0xFFFFFFFFL);
    }

    private static boolean lessThanUnsignedShort(short x1, short x2) {
        if (UnsafeHelp.LITTLE_ENDIAN) {
            x1 = Short.reverseBytes(x1);
            x2 = Short.reverseBytes(x2);
        }
        return (x1 & 0xFFFF) < (x2 & 0xFFFF);
    }
}

