/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GByteArrayOutputStreamWithPos;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.util.Preconditions;

public class GBinaryList<E>
extends AbstractList<BinaryValue> {
    public static final GBinaryList EMPTY_G_BINARY_LIST = new GBinaryList(null, null);
    private static final int HEADER_LENGTH = 4;
    private static final int HEADER_COUNT_OFFSET = 0;
    private final ByteBuffer data;
    private final TypeSerializer<E> valueTypeSerializer;

    public GBinaryList(ByteBuffer data, TypeSerializer<E> valueTypeSerializer) {
        this.data = data != null && data.capacity() == 0 ? null : data;
        this.valueTypeSerializer = valueTypeSerializer;
    }

    @Override
    public BinaryValue get(int index) {
        BinaryValue binaryValue;
        int totalValueCount = this.size();
        if (index >= totalValueCount) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        long seqID = GBinaryList.getSeqIDBytSlot(this.data, index);
        int baseValueOffset = GBinaryList.headerAndIndexLen(totalValueCount);
        int valueIndicate = GBinaryList.getValueIndicate(this.data, baseValueOffset, index);
        GValueType gValueType = GValueType.valueOf((byte)(valueIndicate >>> 28));
        if (gValueType == GValueType.Delete) {
            binaryValue = new BinaryValue(null, GValueType.Delete, seqID, -1, -1);
        } else {
            int endValueOffset = valueIndicate & 0xFFFFFFF;
            int startValueOffset = index == 0 ? totalValueCount * 4 : GBinaryList.getValueIndicate(this.data, GBinaryList.headerAndIndexLen(totalValueCount), index - 1) & 0xFFFFFFF;
            binaryValue = new BinaryValue(this.data, gValueType, seqID, baseValueOffset + startValueOffset, endValueOffset - startValueOffset);
        }
        return binaryValue;
    }

    public int bytesSize() {
        return this.data == null ? 0 : this.data.capacity();
    }

    @Override
    public int size() {
        return this.data == null ? 0 : ByteBufferUtils.toInt(this.data, 0);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public byte[] getDataByte() {
        Preconditions.checkArgument((this.data != null ? 1 : 0) != 0, (Object)"BUG");
        if (this.data.hasArray()) {
            return this.data.array();
        }
        byte[] result = new byte[this.data.capacity()];
        ByteBufferUtils.copyFromBufferToArray(this.data, result, 0, 0, this.data.capacity());
        return result;
    }

    protected static int headerAndIndexLen(int valueCount) {
        return 4 + valueCount * 8;
    }

    private static int getValueOffset(int valueCount) {
        return 4 + valueCount * 8 + valueCount * 4;
    }

    protected static int getValueIndicate(ByteBuffer data, int valueIndicateOffset, int valueIndex) {
        return ByteBufferUtils.toInt(data, valueIndicateOffset + valueIndex * 4);
    }

    private static long getSeqIDBytSlot(ByteBuffer headerBB, int valueCursor) {
        return ByteBufferUtils.toLong(headerBB, 4 + valueCursor * 8);
    }

    private static void writeSeqIDBytSlot(ByteBuffer headerBB, long seqID, int valueCursor) {
        ByteBufferUtils.putLong(headerBB, 4 + valueCursor * 8, seqID);
    }

    private static void writeHeadCount(ByteBuffer headerBB, int totalValues) {
        ByteBufferUtils.putInt(headerBB, 0, totalValues);
    }

    public static <E> GBinaryList<E> ofGBinaryList(List<GSValue<E>> valueList, TypeSerializer<E> valueSerializer, Allocator allocator) {
        try {
            int totalValues = valueList.size();
            if (totalValues == 0) {
                return EMPTY_G_BINARY_LIST;
            }
            byte[] headerAndIndex = new byte[GBinaryList.headerAndIndexLen(totalValues)];
            ByteBuffer headerBB = ByteBuffer.wrap(headerAndIndex);
            GByteArrayOutputStreamWithPos outputStreamForValue = new GByteArrayOutputStreamWithPos();
            DataOutputViewStreamWrapper outputViewForValue = new DataOutputViewStreamWrapper((OutputStream)outputStreamForValue);
            int lastValuePosition = totalValues * 4;
            Iterator<GSValue<E>> iterator = valueList.iterator();
            int valueCursor = 0;
            while (iterator.hasNext()) {
                GSValue<E> gsValue = iterator.next();
                if (gsValue.getValueType() != GValueType.Delete) {
                    outputStreamForValue.setPosition(lastValuePosition);
                    valueSerializer.serialize(gsValue.getValue(), (DataOutputView)outputViewForValue);
                    lastValuePosition = outputStreamForValue.getPosition();
                }
                outputStreamForValue.setPosition(valueCursor * 4);
                int valueIndicator = gsValue.getValueType().getCode() << 28 | lastValuePosition & 0xFFFFFFF;
                IntSerializer.INSTANCE.serialize(Integer.valueOf(valueIndicator), (DataOutputView)outputViewForValue);
                GBinaryList.writeSeqIDBytSlot(headerBB, gsValue.getSeqID(), valueCursor);
                ++valueCursor;
            }
            outputStreamForValue.setPosition(lastValuePosition);
            byte[] valueBytes = outputStreamForValue.getBuf();
            GBinaryList.writeHeadCount(headerBB, totalValues);
            GByteBuffer gByteBuffer = allocator.allocate(headerAndIndex.length + lastValuePosition);
            ByteBufferUtils.copyFromArrayToBuffer(gByteBuffer.getByteBuffer(), 0, headerAndIndex, 0, headerAndIndex.length);
            ByteBufferUtils.copyFromArrayToBuffer(gByteBuffer.getByteBuffer(), headerAndIndex.length, valueBytes, 0, lastValuePosition);
            return new GBinaryList<E>(gByteBuffer.getByteBuffer(), valueSerializer);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("GBinaryHashMap get exception: " + e.getMessage(), e);
        }
    }

    public static <E> GBinaryList<E> mergeGBinaryList(List<GBinaryList<E>> gBinaryListsByOrder, TypeSerializer<E> valueSerializer, Allocator allocator) {
        try {
            int totalValues = gBinaryListsByOrder.stream().map(value -> value.size()).reduce(0, (a, b) -> a + b);
            if (totalValues == 0) {
                return EMPTY_G_BINARY_LIST;
            }
            byte[] headerAndIndex = new byte[GBinaryList.headerAndIndexLen(totalValues)];
            ByteBuffer headerBB = ByteBuffer.wrap(headerAndIndex);
            GByteArrayOutputStreamWithPos outputStreamForValue = new GByteArrayOutputStreamWithPos();
            int lastIndicatorValuePosition = 0;
            int lastValuePosition = totalValues * 4;
            int lastValuePositionOffsetByMerge = totalValues * 4;
            int copyedValueCount = 0;
            for (GBinaryList<E> gBinaryList : gBinaryListsByOrder) {
                int curValueCount = gBinaryList.size();
                if (curValueCount == 0) continue;
                ByteBufferUtils.copyFromBufferToArray(gBinaryList.data, headerAndIndex, 4, 4 + copyedValueCount * 8, curValueCount * 8);
                outputStreamForValue.setPosition(lastIndicatorValuePosition);
                for (int i = 0; i < curValueCount; ++i) {
                    int valueIndicate = GBinaryList.getValueIndicate(gBinaryList.data, GBinaryList.headerAndIndexLen(curValueCount), i);
                    GValueType gValueType = GValueType.valueOf((byte)(valueIndicate >>> 28));
                    int endValueOffset = valueIndicate & 0xFFFFFFF;
                    int startValueOffset = i == 0 ? curValueCount * 4 : GBinaryList.getValueIndicate(gBinaryList.data, GBinaryList.headerAndIndexLen(curValueCount), i - 1) & 0xFFFFFFF;
                    int newValueIndicator = gValueType.getCode() << 28 | (lastValuePositionOffsetByMerge += endValueOffset - startValueOffset) & 0xFFFFFFF;
                    outputStreamForValue.writeInt(newValueIndicator);
                }
                lastIndicatorValuePosition = outputStreamForValue.getPosition();
                outputStreamForValue.setPosition(lastValuePosition);
                outputStreamForValue.write(gBinaryList.data, GBinaryList.getValueOffset(curValueCount), gBinaryList.bytesSize() - GBinaryList.getValueOffset(curValueCount));
                lastValuePosition = outputStreamForValue.getPosition();
                copyedValueCount += curValueCount;
            }
            outputStreamForValue.setPosition(lastValuePosition);
            byte[] valueBytes = outputStreamForValue.getBuf();
            GBinaryList.writeHeadCount(headerBB, totalValues);
            GByteBuffer gByteBuffer = allocator.allocate(headerAndIndex.length + lastValuePosition);
            ByteBufferUtils.copyFromArrayToBuffer(gByteBuffer.getByteBuffer(), 0, headerAndIndex, 0, headerAndIndex.length);
            ByteBufferUtils.copyFromArrayToBuffer(gByteBuffer.getByteBuffer(), headerAndIndex.length, valueBytes, 0, lastValuePosition);
            return new GBinaryList<E>(gByteBuffer.getByteBuffer(), valueSerializer);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("GBinaryHashMap get exception: " + e.getMessage(), e);
        }
    }

    public List<GSValue<E>> toPOJOList() {
        ArrayList<GSValue<GSValue<Object>>> result = new ArrayList<GSValue<GSValue<Object>>>();
        int totalValueCount = this.size();
        if (totalValueCount <= 0) {
            return result;
        }
        try {
            for (int i = 0; i < totalValueCount; ++i) {
                BinaryValue binaryValue = this.get(i);
                if (binaryValue.getgValueType() == GValueType.Delete) {
                    result.add(new GSValue<Object>(null, GValueType.Delete, binaryValue.getSeqID()));
                    continue;
                }
                ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
                Object value = this.valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
                result.add(new GSValue<Object>(value, binaryValue.getgValueType(), binaryValue.getSeqID()));
            }
            return result;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("toPOJOList hash Exception: " + e.getMessage(), e);
        }
    }
}

