/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.util.Comparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;

public class GComparatorBytesImpl<K>
implements GComparator<K> {
    private final Comparator<K> jdkComparator;
    private final TypeSerializer<K> typeSerializer;

    public GComparatorBytesImpl(Comparator<K> jdkComparator, TypeSerializer<K> typeSerializer) {
        this.jdkComparator = jdkComparator;
        this.typeSerializer = typeSerializer;
    }

    @Override
    public int compare(BinaryKey left, BinaryKey right) {
        return ByteBufferUtils.compareTo(left.getBb(), left.getKeyOffset(), left.getKeyLen(), right.getBb(), right.getKeyOffset(), right.getKeyLen());
    }

    @Override
    public int compare(K left, K right) {
        return this.jdkComparator.compare(left, right);
    }

    @Override
    public int compare(K left, BinaryKey right) {
        try {
            ByteBufferDataInputView rightDataInputView = new ByteBufferDataInputView(right.getBb(), right.getKeyOffset(), right.getKeyLen());
            Object rigtK = this.typeSerializer.deserialize((DataInputView)rightDataInputView);
            return this.jdkComparator.compare(left, rigtK);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Comparator<K> getJDKCompactor() {
        return this.jdkComparator;
    }

    @Override
    public Comparator<BinaryKey> getJDKBinaryCompactor() {
        return this::compare;
    }
}

