/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeader;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeaderImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GSortedHeader;

public enum GSortedHeaderImpl implements GSortedHeader,
GHashHeader
{
    WithLongIndexPage(GHashHeaderImpl.LongIndexPage),
    WithIntegerIndexPage(GHashHeaderImpl.IntegerIndexPage);

    private final GHashHeaderImpl gHashHeader;

    private GSortedHeaderImpl(GHashHeaderImpl gHashHeader) {
        this.gHashHeader = gHashHeader;
    }

    public GHashHeaderImpl getgHashHeader() {
        return this.gHashHeader;
    }

    public static GSortedHeaderImpl getPageHelper(int indexLen) {
        if (indexLen <= 65536) {
            return WithIntegerIndexPage;
        }
        return WithLongIndexPage;
    }

    @Override
    public void initIndex(ByteBuffer headerAndIndex, int indexLen) {
        this.gHashHeader.initIndex(headerAndIndex, indexLen);
    }

    @Override
    public long getIndexBySlot(ByteBuffer headerAndIndex, int indexSlot) {
        return this.gHashHeader.getIndexBySlot(headerAndIndex, indexSlot);
    }

    @Override
    public void writeIndexBySlot(ByteBuffer headerAndIndexBB, int indexSlot, long newIndexValue) {
        this.gHashHeader.writeIndexBySlot(headerAndIndexBB, indexSlot, newIndexValue);
    }

    @Override
    public void writeHashCode(ByteBuffer headerAndIndexBB, int indexLen, int keyCursor, int hashCode2) {
        this.gHashHeader.writeHashCode(headerAndIndexBB, indexLen, keyCursor, hashCode2);
    }

    @Override
    public void writeSeqIDBytSlot(ByteBuffer headerAndIndexBB, int indexLen, int totalKeys, long seqID, int keyCursor) {
        this.gHashHeader.writeSeqIDBytSlot(headerAndIndexBB, indexLen, totalKeys, seqID, keyCursor);
    }

    @Override
    public int getHashCode(ByteBuffer headerAndIndexBB, int indexLen, int keyCursor) {
        return this.gHashHeader.getHashCode(headerAndIndexBB, indexLen, keyCursor);
    }

    @Override
    public long getSeqIDBytSlot(ByteBuffer headerAndIndexBB, int indexLen, int totalKeys, int keyCursor) {
        return this.gHashHeader.getSeqIDBytSlot(headerAndIndexBB, indexLen, totalKeys, keyCursor);
    }

    @Override
    public int getCountByIndexValue(long indexValue) {
        return this.gHashHeader.getCountByIndexValue(indexValue);
    }

    @Override
    public int getSlotByIndexValue(long indexValue) {
        return this.gHashHeader.getSlotByIndexValue(indexValue);
    }

    @Override
    public long getInitialIndexValue() {
        return this.gHashHeader.getInitialIndexValue();
    }

    @Override
    public long getNewIndexValue(long oldIndexValue, int slot) {
        return this.gHashHeader.getNewIndexValue(oldIndexValue, slot);
    }

    @Override
    public int getHeaderAndIndexLen(int indexLen, int totalKeys) {
        return this.gHashHeader.getHeaderAndIndexLen(indexLen, totalKeys) + totalKeys * 4;
    }

    @Override
    public int getSortedIndexBaseOffset(int indexLen, int totalKeys) {
        return this.gHashHeader.getHeaderAndIndexLen(indexLen, totalKeys);
    }

    @Override
    public void writeSortedIndexBySlot(ByteBuffer headerAndIndexBB, int baseOffset, int indexSlot, long newIndexValue) {
        ByteBufferUtils.putInt(headerAndIndexBB, baseOffset + indexSlot * 4, (int)newIndexValue);
    }

    @Override
    public int getSortedIndexBySlot(ByteBuffer headerAndIndexBB, int baseOffset, int indexSlot) {
        return ByteBufferUtils.toInt(headerAndIndexBB, baseOffset + indexSlot * 4);
    }
}

