/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeHelp {
    private static final Logger LOG = LoggerFactory.getLogger(UnsafeHelp.class);
    static final Unsafe UNSAFE;
    private static boolean unaligned;
    public static final long BYTE_ARRAY_BASE_OFFSET;
    static final boolean LITTLE_ENDIAN;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private UnsafeHelp() {
    }

    public static boolean isAvailable() {
        return UNSAFE != null;
    }

    public static boolean unaligned() {
        return unaligned;
    }

    public static int toInt(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(UnsafeHelp.getAsInt(buf, offset));
        }
        return UnsafeHelp.getAsInt(buf, offset);
    }

    static int getAsInt(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return UNSAFE.getInt(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return UNSAFE.getInt(buf.array(), BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset);
    }

    public static long toLong(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(UnsafeHelp.getAsLong(buf, offset));
        }
        return UnsafeHelp.getAsLong(buf, offset);
    }

    static long getAsLong(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return UNSAFE.getLong(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return UNSAFE.getLong(buf.array(), BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset);
    }

    public static short toShort(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Short.reverseBytes(UnsafeHelp.getAsShort(buf, offset));
        }
        return UnsafeHelp.getAsShort(buf, offset);
    }

    static short getAsShort(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return UNSAFE.getShort(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return UNSAFE.getShort(buf.array(), BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset);
    }

    public static byte toByte(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return UNSAFE.getByte(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return UNSAFE.getByte(buf.array(), BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset);
    }

    public static int putInt(ByteBuffer buf, int offset, int val) {
        if (LITTLE_ENDIAN) {
            val = Integer.reverseBytes(val);
        }
        if (buf.isDirect()) {
            UNSAFE.putInt(((DirectBuffer)((Object)buf)).address() + (long)offset, val);
        } else {
            UNSAFE.putInt(buf.array(), (long)(offset + buf.arrayOffset()) + BYTE_ARRAY_BASE_OFFSET, val);
        }
        return offset + 4;
    }

    public static int putLong(ByteBuffer buf, int offset, long val) {
        if (LITTLE_ENDIAN) {
            val = Long.reverseBytes(val);
        }
        if (buf.isDirect()) {
            UNSAFE.putLong(((DirectBuffer)((Object)buf)).address() + (long)offset, val);
        } else {
            UNSAFE.putLong(buf.array(), BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset, val);
        }
        return offset + 8;
    }

    public static int putByte(ByteBuffer buf, int offset, byte val) {
        if (buf.isDirect()) {
            UNSAFE.putByte(((DirectBuffer)((Object)buf)).address() + (long)offset, val);
        } else {
            UNSAFE.putByte(buf.array(), BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset, val);
        }
        return offset + 1;
    }

    public static void copy(ByteBuffer src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress;
        long srcAddress;
        byte[] srcBase = null;
        byte[] destBase = null;
        if (src.isDirect()) {
            srcAddress = (long)srcOffset + ((DirectBuffer)((Object)src)).address();
        } else {
            srcAddress = (long)(srcOffset + src.arrayOffset()) + BYTE_ARRAY_BASE_OFFSET;
            srcBase = src.array();
        }
        if (dest.isDirect()) {
            destAddress = (long)destOffset + ((DirectBuffer)((Object)dest)).address();
        } else {
            destAddress = (long)destOffset + BYTE_ARRAY_BASE_OFFSET + (long)dest.arrayOffset();
            destBase = dest.array();
        }
        UnsafeHelp.unsafeCopy(srcBase, srcAddress, destBase, destAddress, length);
    }

    public static void copy(ByteBuffer src, int srcOffset, byte[] dest, int destOffset, int length) {
        long srcAddress = srcOffset;
        byte[] srcBase = null;
        if (src.isDirect()) {
            srcAddress += ((DirectBuffer)((Object)src)).address();
        } else {
            srcAddress = srcAddress + BYTE_ARRAY_BASE_OFFSET + (long)src.arrayOffset();
            srcBase = src.array();
        }
        long destAddress = (long)destOffset + BYTE_ARRAY_BASE_OFFSET;
        UnsafeHelp.unsafeCopy(srcBase, srcAddress, dest, destAddress, length);
    }

    public static void copy(byte[] src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress = destOffset;
        byte[] destBase = null;
        if (dest.isDirect()) {
            destAddress += ((DirectBuffer)((Object)dest)).address();
        } else {
            destAddress = destAddress + BYTE_ARRAY_BASE_OFFSET + (long)dest.arrayOffset();
            destBase = dest.array();
        }
        long srcAddress = (long)srcOffset + BYTE_ARRAY_BASE_OFFSET;
        UnsafeHelp.unsafeCopy(src, srcAddress, destBase, destAddress, length);
    }

    private static void unsafeCopy(Object src, long srcAddr, Object dst, long destAddr, long len) {
        while (len > 0L) {
            long size = len > 0x100000L ? 0x100000L : len;
            UNSAFE.copyMemory(src, srcAddr, dst, destAddr, len);
            len -= size;
            srcAddr += size;
            destAddr += size;
        }
    }

    static {
        LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
        UNSAFE = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null);
                }
                catch (Throwable e) {
                    LOG.warn("sun.misc.Unsafe is not accessible", e);
                    return null;
                }
            }
        });
        if (UNSAFE != null) {
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            try {
                Class<?> clazz = Class.forName("java.nio.Bits");
                Method m = clazz.getDeclaredMethod("unaligned", new Class[0]);
                m.setAccessible(true);
                unaligned = (Boolean)m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                unaligned = false;
            }
        } else {
            BYTE_ARRAY_BASE_OFFSET = -1L;
            unaligned = false;
        }
    }
}

