/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.compress;

import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.LZ4CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.SnappyCompressorCodec;

public enum GCompressAlgorithm {
    None(1){

        @Override
        public CompressorCodec getCompressorCodec() {
            return null;
        }
    }
    ,
    Lz4(2){
        private ThreadLocal<CompressorCodec> compressorCodecThreadLocal = ThreadLocal.withInitial(() -> new LZ4CompressorCodec());

        @Override
        public CompressorCodec getCompressorCodec() {
            return this.compressorCodecThreadLocal.get();
        }
    }
    ,
    Snappy(3){
        private ThreadLocal<CompressorCodec> compressorCodecThreadLocal = ThreadLocal.withInitial(() -> new SnappyCompressorCodec());

        @Override
        public CompressorCodec getCompressorCodec() {
            return this.compressorCodecThreadLocal.get();
        }
    };

    private final byte code;

    private GCompressAlgorithm(byte c) {
        this.code = c;
    }

    public byte getCode() {
        return this.code;
    }

    public static GCompressAlgorithm valueOf(byte gvalueType) {
        switch (gvalueType) {
            case 1: {
                return None;
            }
            case 2: {
                return Lz4;
            }
            case 3: {
                return Snappy;
            }
        }
        return None;
    }

    public abstract CompressorCodec getCompressorCodec();
}

