/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.compress;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockCompressor;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockDecompressor;
import org.apache.flink.api.common.io.blockcompression.Lz4BlockCompressionFactory;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;

public class LZ4CompressorCodec
implements CompressorCodec {
    private final AbstractBlockCompressor compressor;
    private final AbstractBlockDecompressor decompressor;
    private volatile byte[] reusedByteArray;
    private volatile ByteBuffer reusedOffheapBB = ByteBuffer.allocateDirect(16384);

    public LZ4CompressorCodec() {
        Lz4BlockCompressionFactory factory = new Lz4BlockCompressionFactory();
        this.compressor = factory.getCompressor();
        this.decompressor = factory.getDecompressor();
        this.reusedOffheapBB.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte[] getCompressedBytePool(int srcSize) {
        int size = this.compressor.getMaxCompressedSize(srcSize);
        if (this.reusedByteArray == null || this.reusedByteArray.length < size) {
            this.reusedByteArray = new byte[size];
        }
        return this.reusedByteArray;
    }

    @Override
    public ByteBuffer getReuseByteBuffer(int srcSize) {
        if (this.reusedOffheapBB == null || this.reusedOffheapBB.capacity() < srcSize) {
            this.reusedOffheapBB = ByteBuffer.allocateDirect(srcSize);
            this.reusedOffheapBB.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.reusedOffheapBB.clear().limit(srcSize);
        return this.reusedOffheapBB;
    }

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return this.compressor.getMaxCompressedSize(srcSize);
    }

    @Override
    public int compress(ByteBuffer src, ByteBuffer dst) throws GeminiRuntimeException {
        return this.compressor.compress(src, dst);
    }

    @Override
    public int decompress(ByteBuffer src, ByteBuffer dst) throws GeminiRuntimeException {
        return this.decompressor.decompress(src, dst);
    }

    @Override
    public int compress(byte[] src, byte[] dst) throws GeminiRuntimeException {
        return this.compressor.compress(src, dst);
    }

    @Override
    public int decompress(byte[] src, byte[] dst) throws GeminiRuntimeException {
        return this.decompressor.decompress(src, dst);
    }
}

