/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;
import org.xerial.snappy.Snappy;

public class SnappyCompressorCodec
implements CompressorCodec {
    private volatile byte[] reusedByteArray;
    private volatile ByteBuffer reusedOffheapBB = ByteBuffer.allocateDirect(16384);

    public SnappyCompressorCodec() {
        this.reusedOffheapBB.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte[] getCompressedBytePool(int srcSize) {
        if (this.reusedByteArray == null || this.reusedByteArray.length < srcSize) {
            this.reusedByteArray = new byte[srcSize];
        }
        return this.reusedByteArray;
    }

    @Override
    public ByteBuffer getReuseByteBuffer(int srcSize) {
        if (this.reusedOffheapBB == null || this.reusedOffheapBB.capacity() < srcSize) {
            this.reusedOffheapBB = ByteBuffer.allocateDirect(srcSize);
            this.reusedOffheapBB.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.reusedOffheapBB.clear().limit(srcSize);
        return this.reusedOffheapBB;
    }

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return srcSize;
    }

    @Override
    public int compress(ByteBuffer src, ByteBuffer dst) throws GeminiRuntimeException {
        try {
            return Snappy.compress((ByteBuffer)src, (ByteBuffer)dst);
        }
        catch (IOException e) {
            throw new GeminiRuntimeException(e);
        }
    }

    @Override
    public int decompress(ByteBuffer src, ByteBuffer dst) throws GeminiRuntimeException {
        try {
            return Snappy.uncompress((ByteBuffer)src, (ByteBuffer)dst);
        }
        catch (IOException e) {
            throw new GeminiRuntimeException(e);
        }
    }

    @Override
    public int compress(byte[] src, byte[] dst) throws GeminiRuntimeException {
        try {
            return Snappy.compress((byte[])src, (int)0, (int)src.length, (byte[])dst, (int)0);
        }
        catch (IOException e) {
            throw new GeminiRuntimeException(e);
        }
    }

    @Override
    public int decompress(byte[] src, byte[] dst) throws GeminiRuntimeException {
        try {
            return Snappy.uncompress((byte[])src, (int)0, (int)src.length, (byte[])dst, (int)0);
        }
        catch (IOException e) {
            throw new GeminiRuntimeException(e);
        }
    }
}

