/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;

public abstract class AbstractGByteBufferRefence
implements GByteBuffer {
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private volatile long seqID;
    protected final Allocator allocator;

    public AbstractGByteBufferRefence(Allocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public void contain() {
        this.referenceCount.incrementAndGet();
    }

    @Override
    public void release(ReferenceCount.ReleaseType releaseType) throws GeminiRuntimeException {
        int count = this.referenceCount.decrementAndGet();
        if (count == 0) {
            if (this.allocator != null) {
                this.allocator.release(releaseType, this);
            } else {
                this.doFree();
            }
        }
    }

    @Override
    public int getCnt() {
        return this.referenceCount.get();
    }

    @Override
    public void setSeqID(long seqID) {
        this.seqID = seqID;
    }

    @Override
    public long getSeqID() {
        return this.seqID;
    }
}

