/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.AbstractGByteBufferRefence;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.Chunk;

public class GPooledByteBuffer
extends AbstractGByteBufferRefence {
    private final ByteBuffer byteBuffer;
    private volatile Chunk chunk;
    private final int offset;
    private final int len;

    public GPooledByteBuffer(Chunk chunk, int offset, int len, Allocator allocator) {
        super(allocator);
        this.chunk = chunk;
        ByteBuffer duplicateByteBuffer = chunk.getMemory().duplicate();
        duplicateByteBuffer.limit(offset + len);
        duplicateByteBuffer.position(offset);
        this.byteBuffer = duplicateByteBuffer.slice();
        this.offset = offset;
        this.len = len;
        this.contain();
    }

    @Override
    public int capacity() {
        return this.byteBuffer.capacity();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFree() throws GeminiRuntimeException {
        if (this.chunk == null) {
            return;
        }
        GPooledByteBuffer gPooledByteBuffer = this;
        synchronized (gPooledByteBuffer) {
            if (this.chunk != null) {
                this.chunk.free(this.offset, this.len);
                this.chunk = null;
                this.allocator.statSize(-this.len);
            }
        }
    }
}

