/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.AbstractGByteBufferRefence;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPooledNettyByteBuffer
extends AbstractGByteBufferRefence {
    private static final Logger LOG = LoggerFactory.getLogger(GPooledNettyByteBuffer.class);
    private final ByteBuffer byteBuffer;
    private volatile ByteBuf byteBuf;
    private final int len;

    public GPooledNettyByteBuffer(ByteBuf byteBuf, int len, Allocator allocator) {
        super(allocator);
        this.byteBuf = byteBuf;
        this.byteBuffer = byteBuf.nioBuffer(0, len);
        this.len = len;
        this.contain();
    }

    @Override
    public int capacity() {
        return this.len;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @VisibleForTesting
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFree() throws GeminiRuntimeException {
        if (this.byteBuf == null) {
            return;
        }
        GPooledNettyByteBuffer gPooledNettyByteBuffer = this;
        synchronized (gPooledNettyByteBuffer) {
            if (this.byteBuf != null) {
                if (!this.byteBuf.release()) {
                    LOG.error("FATAL BUG!!! LEAK! pls contact to dev. byteBuf ref =" + this.byteBuf.refCnt());
                }
                this.byteBuf = null;
                this.allocator.statSize(-this.len);
            }
        }
    }
}

