/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.dbms.DiscardOrEvictPageReleaseManager;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiException;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GPooledNettyByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.PooledByteBufAllocator;

public class PoolAllocatorNettyImpl
implements Allocator {
    private final PooledByteBufAllocator pooledByteBufAllocator;
    private final AtomicLong currentSize = new AtomicLong(0L);
    private final DiscardOrEvictPageReleaseManager discardOrEvictPageReleaseManager;

    public PoolAllocatorNettyImpl(GConfiguration gConfiguration, DiscardOrEvictPageReleaseManager discardOrEvictPageReleaseManager) {
        int pageSize = 8192;
        int maxOrder = 11;
        int normalCacheSize = 16;
        int nDirectArena = Math.min(gConfiguration.getAllocatorDirectArena(), (int)(gConfiguration.getTotalOffheapMemSize() / (long)(pageSize << maxOrder) / 3L / 2L));
        this.pooledByteBufAllocator = new PooledByteBufAllocator(true, 0, nDirectArena, pageSize, maxOrder, 0, 0, normalCacheSize);
        this.discardOrEvictPageReleaseManager = discardOrEvictPageReleaseManager;
    }

    @Override
    public GByteBuffer allocate(int len) throws GeminiException {
        ByteBuf byteBuf = this.pooledByteBufAllocator.buffer(len);
        this.currentSize.addAndGet(len);
        return new GPooledNettyByteBuffer(byteBuf, len, this);
    }

    @Override
    public void close() {
    }

    @Override
    public void release(ReferenceCount.ReleaseType releaseType, GByteBuffer gByteBuffer) {
        switch (releaseType) {
            case Discard: 
            case Evict: {
                this.discardOrEvictPageReleaseManager.addWaitSafeQueue(releaseType, gByteBuffer);
                break;
            }
            case Normal: {
                gByteBuffer.doFree();
                break;
            }
            default: {
                throw new GeminiRuntimeException("release invalid type:" + (Object)((Object)releaseType));
            }
        }
    }

    @Override
    public void statSize(int len) {
        this.currentSize.addAndGet(len);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pooledByteBufAllocator", (Object)this.pooledByteBufAllocator).add("currentSize", (Object)this.currentSize).toString();
    }
}

