/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiException;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GUnPooledByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class UnpoolAllocatorImpl
implements Allocator {
    private final AtomicLong currentSize = new AtomicLong(0L);

    @Override
    public GByteBuffer allocate(int len) throws GeminiException {
        this.currentSize.addAndGet(len);
        return new GUnPooledByteBuffer(ByteBuffer.allocate(len), len, this);
    }

    @Override
    public void close() {
    }

    @Override
    public void release(ReferenceCount.ReleaseType releaseType, GByteBuffer gByteBuffer) {
    }

    @Override
    public void statSize(int len) {
        this.currentSize.addAndGet(-len);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currentSize", (Object)this.currentSize).toString();
    }
}

