/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.SnapshotDirectory;

public class BackendSnapshotMeta {
    private final long checkpointId;
    private final long timestamp;
    @Nullable
    private final SnapshotDirectory localSnapshotDir;

    public BackendSnapshotMeta(long checkpointId, long timestamp) {
        this(checkpointId, timestamp, null);
    }

    public BackendSnapshotMeta(long checkpointId, long timestamp, SnapshotDirectory localSnapshotDir) {
        this.checkpointId = checkpointId;
        this.timestamp = timestamp;
        this.localSnapshotDir = localSnapshotDir;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isLocalSnapshotEnabled() {
        return this.getLocalSnapshotDir() != null;
    }

    public SnapshotDirectory getLocalSnapshotDir() {
        return this.localSnapshotDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackendSnapshotMeta that = (BackendSnapshotMeta)o;
        return this.checkpointId == that.checkpointId && this.timestamp == that.timestamp && Objects.equals(this.localSnapshotDir, that.localSnapshotDir);
    }

    public int hashCode() {
        int result = (int)(this.checkpointId ^ this.checkpointId >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + Objects.hashCode(this.localSnapshotDir);
        return result;
    }

    public String toString() {
        return "BackendSnapshotMeta{, checkpointId=" + this.checkpointId + ", timestamp=" + this.timestamp + ", localSnapshotDir=" + Objects.toString(this.localSnapshotDir) + '}';
    }
}

