/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.Serializable;
import java.util.Objects;

public class DBSnapshotMeta
implements Serializable {
    private static final long serialVersionUID = 6595214484441644131L;
    private final String snapshotMetaPath;
    private final int startRegionId;
    private final int endRegionId;
    private final long checkpointId;
    private final long snapshotMetaSize;
    private final long incrementalSize;
    private final long fullSize;

    public DBSnapshotMeta(long checkpointId, int startRegionId, int endRegionId, long snapshotMetaSize, long fullSize, long incrementalSize, String snapshotMetaPath) {
        this.checkpointId = checkpointId;
        this.startRegionId = startRegionId;
        this.endRegionId = endRegionId;
        this.snapshotMetaSize = snapshotMetaSize;
        this.fullSize = fullSize;
        this.incrementalSize = incrementalSize;
        this.snapshotMetaPath = snapshotMetaPath;
    }

    public String getSnapshotMetaPath() {
        return this.snapshotMetaPath;
    }

    public int getStartRegionId() {
        return this.startRegionId;
    }

    public int getEndRegionId() {
        return this.endRegionId;
    }

    public long getCheckPointId() {
        return this.checkpointId;
    }

    public long getSnapshotMetaSize() {
        return this.snapshotMetaSize;
    }

    public long getFullSize() {
        return this.fullSize;
    }

    public long getIncrementalSize() {
        return this.incrementalSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBSnapshotMeta that = (DBSnapshotMeta)o;
        return this.checkpointId == that.checkpointId && this.startRegionId == that.startRegionId && this.endRegionId == that.endRegionId && this.snapshotMetaSize == that.snapshotMetaSize && this.fullSize == that.fullSize && this.incrementalSize == that.incrementalSize && Objects.equals(this.snapshotMetaPath, that.snapshotMetaPath);
    }

    public int hashCode() {
        int result = this.startRegionId;
        result = 31 * result + this.endRegionId;
        result = 31 * result + (int)(this.checkpointId ^ this.checkpointId >>> 32);
        result = 31 * result + (int)(this.snapshotMetaSize ^ this.snapshotMetaSize >>> 32);
        result = 31 * result + (int)(this.fullSize ^ this.fullSize >>> 32);
        result = 31 * result + (int)(this.incrementalSize ^ this.incrementalSize >>> 32);
        result = 31 * result + this.snapshotMetaPath.hashCode();
        return result;
    }

    public String toString() {
        return "DBSnapshotMeta{, checkpointId=" + this.checkpointId + ", startRegionId=" + this.startRegionId + ", endRegionId=" + this.endRegionId + ", snapshotMetaSize=" + this.snapshotMetaSize + ", fullSize=" + this.fullSize + ", incrementalSize=" + this.incrementalSize + ", snapshotMetaPath=" + this.snapshotMetaPath + '}';
    }
}

