/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;

public class DBSnapshotMetaSerializer
extends TypeSerializerSingleton<DBSnapshotMeta> {
    private static final long serialVersionUID = 1L;
    public static final DBSnapshotMetaSerializer INSTANCE = new DBSnapshotMetaSerializer();

    public boolean isImmutableType() {
        return true;
    }

    public DBSnapshotMeta createInstance() {
        throw new UnsupportedOperationException();
    }

    public DBSnapshotMeta copy(DBSnapshotMeta from) {
        return new DBSnapshotMeta(from.getCheckPointId(), from.getStartRegionId(), from.getEndRegionId(), from.getSnapshotMetaSize(), from.getFullSize(), from.getIncrementalSize(), from.getSnapshotMetaPath());
    }

    public DBSnapshotMeta copy(DBSnapshotMeta from, DBSnapshotMeta reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DBSnapshotMeta record, DataOutputView target) throws IOException {
        target.writeLong(record.getCheckPointId());
        target.writeInt(record.getStartRegionId());
        target.writeInt(record.getEndRegionId());
        target.writeLong(record.getSnapshotMetaSize());
        target.writeLong(record.getFullSize());
        target.writeLong(record.getIncrementalSize());
        target.writeUTF(record.getSnapshotMetaPath());
    }

    public DBSnapshotMeta deserialize(DataInputView source) throws IOException {
        return new DBSnapshotMeta(source.readLong(), source.readInt(), source.readInt(), source.readLong(), source.readLong(), source.readLong(), source.readUTF());
    }

    public DBSnapshotMeta deserialize(DBSnapshotMeta reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeInt(source.readInt());
    }

    public boolean canEqual(Object obj) {
        return obj instanceof DBSnapshotMeta;
    }

    protected boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return super.isCompatibleSerializationFormatIdentifier(identifier) || identifier.equals(DBSnapshotMeta.class.getCanonicalName());
    }
}

