/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.state.SnapshotDirectory;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotResult;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManagerImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotOperation;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotStat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAndDFSSnapshotOperation
extends SnapshotOperation {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAndDFSSnapshotOperation.class);
    private final FileManager dfsFileManager;
    private final FileManager localFileManager;
    private SnapshotManager.PendingSnapshot pendingSnapshot;

    public LocalAndDFSSnapshotOperation(GContext gContext, SnapshotManager snapshotManager, FileManager dfsFileManager, FileManager localFileManager) {
        super(gContext, snapshotManager);
        this.dfsFileManager = (FileManager)Preconditions.checkNotNull((Object)dfsFileManager);
        this.localFileManager = (FileManager)Preconditions.checkNotNull((Object)localFileManager);
    }

    @Override
    public SnapshotManager.PendingSnapshot createPendingSnapshot(BackendSnapshotMeta backendSnapshotMeta, long accessNumber) {
        long checkpointId = backendSnapshotMeta.getCheckpointId();
        SnapshotCompletableFuture snapshotCompletableFuture = new SnapshotCompletableFuture(this.gContext, this.gContext.getSupervisor().getSnapshotExecutorGroup());
        Path dfsSnapshotBasePath = this.dfsFileManager.getBasePath();
        Path dfsMetaPath = ((SnapshotManagerImpl)this.snapshotManager).getDFSSnapshotMetaPath(dfsSnapshotBasePath, checkpointId);
        Path localSnapshotBasePath = backendSnapshotMeta.getLocalSnapshotDir().getDirectory();
        Path localMetaPath = ((SnapshotManagerImpl)this.snapshotManager).getLocalSnapshotMetaPath(localSnapshotBasePath, checkpointId);
        SnapshotManager.PendingSnapshot pendingSnapshot = new SnapshotManager.PendingSnapshot(checkpointId, backendSnapshotMeta.getTimestamp(), snapshotCompletableFuture, dfsSnapshotBasePath, dfsMetaPath, localSnapshotBasePath, localMetaPath, accessNumber, this);
        snapshotCompletableFuture.setPendingSnapshot(pendingSnapshot);
        this.pendingSnapshot = pendingSnapshot;
        return pendingSnapshot;
    }

    @Override
    public SnapshotManager.PendingSnapshot getPendingSnapshot() {
        return this.pendingSnapshot;
    }

    @Override
    public DBSnapshotResult getSnapshotResult() throws Exception {
        SnapshotMetaFile.Writer localWriter = null;
        SnapshotMetaFile.Writer dfsWriter = null;
        try {
            localWriter = SnapshotMetaFile.getWriter(this.pendingSnapshot.getLocalSnapshotMetaPath());
            RegionSnapshot localRegionSnapshot = new RegionSnapshot(this.localFileManager, this.dfsFileManager, localWriter);
            dfsWriter = SnapshotMetaFile.getWriter(this.pendingSnapshot.getSnapshotMetaPath());
            RegionSnapshot dfsRegionSnapshot = new RegionSnapshot(null, this.dfsFileManager, dfsWriter);
            HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>> dfsFileMapping = new HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>>();
            HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>> localFileMapping = new HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>>();
            this.writePageIndex(this.pendingSnapshot.getGRegionSnapshotMeta(), localWriter, dfsWriter, localRegionSnapshot, dfsRegionSnapshot, localFileMapping, dfsFileMapping);
            this.pendingSnapshot.setLocalFileMapping(localFileMapping);
            this.pendingSnapshot.setFileMapping(dfsFileMapping);
            this.writeLocalAndDfsFileMapping(this.pendingSnapshot, localWriter, this.localFileManager, this.dfsFileManager);
            this.writeLocalAndDfsFileMapping(this.pendingSnapshot, dfsWriter, null, this.dfsFileManager);
            long localSnapshotMetaSize = localWriter.getPos();
            long dfsSnapshotMetaSize = dfsWriter.getPos();
            SnapshotStat snapshotStat = this.pendingSnapshot.getSnapshotStat();
            snapshotStat.addAndGetTotalLoalFiles(localFileMapping.size());
            snapshotStat.setLocalMetaFileSize(localSnapshotMetaSize);
            snapshotStat.addAndGetTotalFiles(dfsFileMapping.size());
            snapshotStat.setMetaFileSize(dfsSnapshotMetaSize);
            this.createHardLinkForLocalFiles(this.pendingSnapshot.getLocalSnapshotBasePath(), localFileMapping.keySet());
            DBSnapshotMeta localDBSnapshotMeta = new DBSnapshotMeta(this.pendingSnapshot.getCheckpointId(), this.gContext.getStartRegionId(), this.gContext.getEndRegionId(), localSnapshotMetaSize, snapshotStat.addAndGetTotalLocalSize(0L), snapshotStat.addAndGetLocalIncrementalSize(0L), localWriter.getFilePath().toUri().toString());
            DBSnapshotMeta dfsDBSnapshotMeta = new DBSnapshotMeta(this.pendingSnapshot.getCheckpointId(), this.gContext.getStartRegionId(), this.gContext.getEndRegionId(), dfsSnapshotMetaSize, snapshotStat.addAndGetTotalSize(0L), snapshotStat.addAndGetIncrementalSize(0L), dfsWriter.getFilePath().toUri().toString());
            localWriter.close();
            dfsWriter.close();
            return new DBSnapshotResult(SnapshotDirectory.permanent(this.pendingSnapshot.getLocalSnapshotBasePath()), localDBSnapshotMeta, SnapshotDirectory.permanent(this.pendingSnapshot.getSnapshotBasePath()), dfsDBSnapshotMeta);
        }
        catch (Exception e) {
            LOG.error("failed to snapshot meta for {}, {}", (Object)this.pendingSnapshot.getCheckpointId(), (Object)e.toString());
            this.closeAndDeleteWriterQuietly(localWriter);
            this.closeAndDeleteWriterQuietly(dfsWriter);
            throw e;
        }
    }

    @VisibleForTesting
    void createHardLinkForLocalFiles(Path snapshotBasePath, Set<Integer> fileIds) throws Exception {
        FileSystem fileSystem = snapshotBasePath.getFileSystem();
        if (!(fileSystem instanceof LocalFileSystem)) {
            LOG.error("expected LocalFilSystem, actual {}", (Object)fileSystem);
            throw new GeminiRuntimeException("hard link only works for local file system, actual " + fileSystem);
        }
        File snapshotBaseDir = new File(snapshotBasePath.toUri());
        for (int fileId : fileIds) {
            File file = new File(this.localFileManager.getFilePath(fileId));
            try {
                Files.createLink(new File(snapshotBaseDir, file.getName()).toPath(), file.toPath());
            }
            catch (Exception e) {
                LOG.error("Fail to create hard link from {} to {}, {}", new Object[]{file.getAbsolutePath(), snapshotBasePath.toUri().toString(), e});
                throw e;
            }
        }
    }
}

