/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.util.Preconditions;

public class RegionSnapshot {
    @Nullable
    private final FileManager localFileManager;
    private final FileManager dfsFileManager;
    private final SnapshotMetaFile.Writer writer;
    private int region;
    private Map<Integer, Tuple2<Integer, Long>> regionLocalFileMeta;
    private Map<Integer, Tuple2<Integer, Long>> regionDfsFileMeta;

    public RegionSnapshot(@Nullable FileManager localFileManager, FileManager dfsFileManager, SnapshotMetaFile.Writer writer) {
        this.localFileManager = localFileManager;
        this.dfsFileManager = (FileManager)Preconditions.checkNotNull((Object)dfsFileManager);
        this.writer = (SnapshotMetaFile.Writer)Preconditions.checkNotNull((Object)writer);
        this.regionLocalFileMeta = new HashMap<Integer, Tuple2<Integer, Long>>();
        this.regionDfsFileMeta = new HashMap<Integer, Tuple2<Integer, Long>>();
    }

    public int getRegion() {
        return this.region;
    }

    public SnapshotMetaFile.Writer getWriter() {
        return this.writer;
    }

    public Map<Integer, Tuple2<Integer, Long>> getRegionLocalFileMeta() {
        return this.regionLocalFileMeta;
    }

    public Map<Integer, Tuple2<Integer, Long>> getRegionDfsFileMeta() {
        return this.regionDfsFileMeta;
    }

    public void updateFileMeta(long address, int reference, long size, boolean isLocal) {
        Tuple2 meta;
        Map<Integer, Tuple2<Integer, Long>> regionFileMeta = isLocal ? this.regionLocalFileMeta : this.regionDfsFileMeta;
        int fileId = isLocal ? this.localFileManager.getFileID(address).get() : this.dfsFileManager.getFileID(address).get();
        Tuple2 tuple2 = meta = regionFileMeta.computeIfAbsent(fileId, no -> Tuple2.of((Object)0, (Object)0L));
        tuple2.f0 = (Integer)tuple2.f0 + reference;
        tuple2 = meta;
        tuple2.f1 = (Long)tuple2.f1 + size;
    }

    public void reset(int newRegion) {
        this.region = newRegion;
        if (this.regionLocalFileMeta != null) {
            this.regionLocalFileMeta.clear();
        } else {
            this.regionLocalFileMeta = new HashMap<Integer, Tuple2<Integer, Long>>();
        }
        if (this.regionDfsFileMeta != null) {
            this.regionDfsFileMeta.clear();
        } else {
            this.regionDfsFileMeta = new HashMap<Integer, Tuple2<Integer, Long>>();
        }
    }
}

