/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutorGroup;

public class SnapshotCompletableFuture
extends CompletableFuture<Boolean> {
    private final GContext gContext;
    private final AtomicInteger runningTasks;
    private final EventExecutorGroup snapshotEventExecutorGroup;
    private final AtomicBoolean endSnapshot;
    private SnapshotManager.PendingSnapshot pendingSnapshot;

    public SnapshotCompletableFuture(GContext gContext, EventExecutorGroup snapshotEventExecutorGroup) {
        this(gContext, 0, snapshotEventExecutorGroup);
    }

    public SnapshotCompletableFuture(GContext gContext, int initRunningTasks, EventExecutorGroup snapshotEventExecutorGroup) {
        this.gContext = gContext;
        this.runningTasks = new AtomicInteger(initRunningTasks);
        this.snapshotEventExecutorGroup = snapshotEventExecutorGroup;
        this.endSnapshot = new AtomicBoolean(false);
    }

    public void incRunningTask() {
        this.runningTasks.incrementAndGet();
    }

    public void decRunningTask() {
        int left = this.runningTasks.decrementAndGet();
        if (left <= 0) {
            for (EventExecutor eventExecutor : this.snapshotEventExecutorGroup) {
                if (this.isCancelled() || this.isCompletedExceptionally()) {
                    return;
                }
                try {
                    this.gContext.getSupervisor().getFileCache().sync(eventExecutor);
                }
                catch (Exception e) {
                    this.completeExceptionally(e);
                }
            }
            this.complete(true);
        }
    }

    public void setPendingSnapshot(SnapshotManager.PendingSnapshot pendingSnapshot) {
        this.pendingSnapshot = pendingSnapshot;
    }

    public SnapshotManager.PendingSnapshot getPendingSnapshot() {
        return this.pendingSnapshot;
    }

    public boolean isEndSnapshot() {
        return this.endSnapshot.get();
    }

    public void setEndSnapshot() {
        this.endSnapshot.set(true);
    }
}

