/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.IOException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiDataInputStream;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiDataOutputStream;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiInputStream;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiOutputStream;
import org.apache.flink.util.Preconditions;

public class SnapshotMetaFile {
    public static Writer getWriter(Path filePath) throws IOException {
        GeminiOutputStream outputStream = new GeminiOutputStream(filePath, FileSystem.WriteMode.OVERWRITE);
        return new WriterImpl(filePath, outputStream);
    }

    public static Reader getReader(Path filePath) throws IOException {
        GeminiInputStream inputStream = new GeminiInputStream(filePath);
        return new ReaderImpl(filePath, inputStream);
    }

    public static class ReaderImpl
    extends Reader {
        private final Path filePath;

        public ReaderImpl(Path filePath, GeminiInputStream inputStream) throws IOException {
            super(inputStream);
            this.filePath = (Path)Preconditions.checkNotNull((Object)filePath);
        }
    }

    public static abstract class Reader
    extends GeminiDataInputStream {
        public Reader(GeminiInputStream inputStream) {
            super(inputStream);
        }
    }

    public static class WriterImpl
    extends Writer {
        public WriterImpl(Path filePath, GeminiOutputStream outputStream) {
            super(filePath, outputStream);
        }
    }

    public static abstract class Writer
    extends GeminiDataOutputStream {
        private final Path filePath;

        public Writer(Path filePath, GeminiOutputStream outputStream) {
            super(outputStream);
            this.filePath = filePath;
        }

        public Path getFilePath() {
            return this.filePath;
        }
    }
}

