/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotResult;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManagerImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnapshotOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotOperation.class);
    protected final GContext gContext;
    protected final SnapshotManager snapshotManager;

    SnapshotOperation(GContext gContext, SnapshotManager snapshotManager) {
        this.gContext = (GContext)Preconditions.checkNotNull((Object)gContext);
        this.snapshotManager = (SnapshotManager)Preconditions.checkNotNull((Object)snapshotManager);
    }

    public abstract SnapshotManager.PendingSnapshot createPendingSnapshot(BackendSnapshotMeta var1, long var2);

    public abstract SnapshotManager.PendingSnapshot getPendingSnapshot();

    public abstract DBSnapshotResult getSnapshotResult() throws Exception;

    void writePageIndex(Map<String, Map<GRegionID, SnapshotManager.GRegionSnapshotMeta>> copiedPageIndex, @Nullable SnapshotMetaFile.Writer localWriter, SnapshotMetaFile.Writer dfsWriter, @Nullable RegionSnapshot localRegionSnapshot, RegionSnapshot dfsRegionSnapshot, @Nullable Map<Integer, Map<Integer, Tuple2<Integer, Long>>> localFileMapping, Map<Integer, Map<Integer, Tuple2<Integer, Long>>> dfsFileMapping) throws IOException {
        this.writeInt(localWriter, dfsWriter, copiedPageIndex.size());
        for (Map.Entry<String, Map<GRegionID, SnapshotManager.GRegionSnapshotMeta>> te : copiedPageIndex.entrySet()) {
            String tableName = te.getKey();
            Map<GRegionID, SnapshotManager.GRegionSnapshotMeta> regionMetas = te.getValue();
            this.writeUTF(localWriter, dfsWriter, tableName);
            this.writeInt(localWriter, dfsWriter, regionMetas.size());
            for (Map.Entry<GRegionID, SnapshotManager.GRegionSnapshotMeta> re : regionMetas.entrySet()) {
                this.writeInt(localWriter, dfsWriter, re.getKey().getRegionCode());
                SnapshotManager.GRegionSnapshotMeta meta = re.getValue();
                this.writeLong(localWriter, dfsWriter, meta.getLastSeqID());
                this.writeLong(localWriter, dfsWriter, meta.getRemoveAllSeqID());
                int groupId = re.getKey().getId();
                if (localRegionSnapshot != null) {
                    localRegionSnapshot.reset(groupId);
                }
                dfsRegionSnapshot.reset(groupId);
                meta.getPageIndex().snapshot(localRegionSnapshot, dfsRegionSnapshot);
                if (localFileMapping != null) {
                    this.updateFileMapping(localFileMapping, localRegionSnapshot.getRegionLocalFileMeta(), groupId);
                }
                this.updateFileMapping(dfsFileMapping, dfsRegionSnapshot.getRegionDfsFileMeta(), groupId);
            }
        }
    }

    void writeLocalAndDfsFileMapping(SnapshotManager.PendingSnapshot pendingSnapshot, SnapshotMetaFile.Writer writer, @Nullable FileManager localFileManager, FileManager dfsFileManager) throws IOException {
        long dfsMappingOffset = writer.getPos();
        this.writeFileMapping(writer, dfsFileManager, pendingSnapshot.getSnapshotBasePath(), pendingSnapshot.getFileMapping(), false);
        long localMappingOffset = writer.getPos();
        this.writeFileMapping(writer, localFileManager, pendingSnapshot.getLocalSnapshotBasePath(), pendingSnapshot.getLocalFileMapping(), true);
        writer.writeLong(dfsMappingOffset);
        writer.writeLong(localMappingOffset);
    }

    void closeAndDeleteWriterQuietly(SnapshotMetaFile.Writer writer) {
        if (writer != null) {
            Path path = writer.getFilePath();
            try {
                writer.close();
            }
            catch (IOException ioe) {
                LOG.warn("Failed to close meta writer, {}, {}.", (Object)path.toUri().toString(), (Object)ioe);
            }
            try {
                FileSystem fileSystem = path.getFileSystem();
                fileSystem.delete(path, false);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to delete meta file, {}, {}.", (Object)path.toUri().toString(), (Object)ioe);
            }
        }
    }

    private void writeFileMapping(SnapshotMetaFile.Writer writer, FileManager fileManager, Path snapshotBasePath, Map<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping, boolean isLocal) throws IOException {
        if (fileManager == null) {
            writer.writeBoolean(false);
        } else {
            writer.writeBoolean(true);
            writer.writeInt(fileMapping.size());
            writer.writeUTF(snapshotBasePath.toUri().toString());
            if (fileMapping.size() > 0) {
                for (Integer fileId : fileMapping.keySet()) {
                    String path = fileManager.getFilePath(fileId);
                    writer.writeUTF(isLocal ? new Path(path).getName() : path);
                    writer.writeInt(fileId);
                }
                MapSerializer<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMappingSerializer = ((SnapshotManagerImpl)this.snapshotManager).getFileMappingSerializer();
                DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper((OutputStream)((Object)writer));
                fileMappingSerializer.serialize(fileMapping, (DataOutputView)dataOutputView);
            }
        }
    }

    private void writeInt(SnapshotMetaFile.Writer localWriter, SnapshotMetaFile.Writer dfsWriter, int value) throws IOException {
        if (localWriter != null) {
            localWriter.writeInt(value);
        }
        if (dfsWriter != null) {
            dfsWriter.writeInt(value);
        }
    }

    private void writeLong(SnapshotMetaFile.Writer localWriter, SnapshotMetaFile.Writer dfsWriter, long value) throws IOException {
        if (localWriter != null) {
            localWriter.writeLong(value);
        }
        if (dfsWriter != null) {
            dfsWriter.writeLong(value);
        }
    }

    private void writeUTF(SnapshotMetaFile.Writer localWriter, SnapshotMetaFile.Writer dfsWriter, String value) throws IOException {
        if (localWriter != null) {
            localWriter.writeUTF(value);
        }
        if (dfsWriter != null) {
            dfsWriter.writeUTF(value);
        }
    }

    private void updateFileMapping(Map<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping, Map<Integer, Tuple2<Integer, Long>> regionFileMeta, int groupId) {
        for (Map.Entry<Integer, Tuple2<Integer, Long>> entry : regionFileMeta.entrySet()) {
            Tuple2 tuple;
            int fileId = entry.getKey();
            Map groupStat = fileMapping.computeIfAbsent(fileId, nothing -> new HashMap());
            Tuple2 tuple2 = tuple = groupStat.computeIfAbsent(groupId, nothing -> Tuple2.of((Object)0, (Object)0L));
            Integer.valueOf((Integer)tuple2.f0 + (Integer)entry.getValue().f0);
            tuple2.f0 = tuple2.f0;
            tuple2 = tuple;
            Long.valueOf((Long)tuple2.f1 + (Long)entry.getValue().f1);
            tuple2.f1 = tuple2.f1;
        }
    }
}

