/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.utils;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.util.Preconditions;

public class ThreadLocalTypeSerializer<T, S extends TypeSerializer<T>>
extends TypeSerializer<T> {
    private final S originSerializer;
    private final ThreadLocal<S> threadLocalSerializer;

    public ThreadLocalTypeSerializer(S serializer) {
        this.originSerializer = (TypeSerializer)Preconditions.checkNotNull(serializer);
        this.threadLocalSerializer = new ThreadLocal();
        this.threadLocalSerializer.set(serializer);
    }

    public static <T, S extends TypeSerializer<T>> ThreadLocalTypeSerializer<T, S> of(S serializer) {
        return new ThreadLocalTypeSerializer<T, S>(serializer);
    }

    public S getOriginSerializer() {
        return this.originSerializer;
    }

    @VisibleForTesting
    S getSerializer() {
        TypeSerializer serializer = (TypeSerializer)this.threadLocalSerializer.get();
        if (serializer == null) {
            serializer = this.originSerializer.duplicate();
            this.threadLocalSerializer.set(serializer);
        }
        return (S)serializer;
    }

    public boolean isImmutableType() {
        return this.originSerializer.isImmutableType();
    }

    public TypeSerializer<T> duplicate() {
        throw new UnsupportedOperationException("serializer duplication should not happen in GeminiDB");
    }

    public T createInstance() {
        return (T)this.getSerializer().createInstance();
    }

    public T copy(T from) {
        return (T)this.getSerializer().copy(from);
    }

    public T copy(T from, T reuse) {
        return (T)this.getSerializer().copy(from, reuse);
    }

    public int getLength() {
        return this.originSerializer.getLength();
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        this.getSerializer().serialize(record, target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return (T)this.getSerializer().deserialize(source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return (T)this.getSerializer().deserialize(reuse, source);
    }

    public int serializeToPages(T record, AbstractPagedOutputView target) throws IOException {
        return this.getSerializer().serializeToPages(record, target);
    }

    public T deserializeFromPages(AbstractPagedInputView source) throws IOException {
        return (T)this.getSerializer().deserializeFromPages(source);
    }

    public T deserializeFromPages(T reuse, AbstractPagedInputView source) throws IOException {
        return (T)this.getSerializer().deserializeFromPages(reuse, source);
    }

    public T mapFromPages(AbstractPagedInputView source) throws IOException {
        return (T)this.getSerializer().mapFromPages(source);
    }

    public T mapFromPages(T reuse, AbstractPagedInputView source) throws IOException {
        return (T)this.getSerializer().mapFromPages(reuse, source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.getSerializer().copy(source, target);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadLocalTypeSerializer) {
            ThreadLocalTypeSerializer other = (ThreadLocalTypeSerializer)((Object)obj);
            return other.canEqual((Object)this) && other.originSerializer.equals(this.originSerializer);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ThreadLocalTypeSerializer;
    }

    public int hashCode() {
        return this.originSerializer.hashCode();
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        throw new UnsupportedOperationException("thread local serializer is only used in GeminiDB");
    }

    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        throw new UnsupportedOperationException("thread local serializer is only used in GeminiDB");
    }
}

