/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.dbms.Supervisor;
import org.apache.flink.runtime.state.gemini.engine.vm.CacheManager;
import org.apache.flink.runtime.state.gemini.engine.vm.CacheStats;
import org.apache.flink.runtime.state.gemini.engine.vm.EvictPolicy;
import org.apache.flink.runtime.state.gemini.engine.vm.EvictPolicySepImpl;
import org.apache.flink.runtime.state.gemini.engine.vm.WaterMark;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManagerImpl
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManagerImpl.class);
    private final GContext gContext;
    private final Supervisor supervisor;
    private final long totalHeapMemSize;
    private final long totalOffheapMemSize;
    private final long totalMemSize;
    private final long totalMemLowMark;
    private final long totalMemMiddleMark;
    private final long totalMemHighMark;
    private final long totalIndexCountHighMark;
    private final long totalIndexCountLowMark;
    private EvictPolicy evictPolicy;
    private final CacheStats cacheStats = new CacheStats();
    private final ExecutorService cacheManagerExecutor;
    private final int readPageCacheLRUSize;

    public CacheManagerImpl(GContext gContext) {
        this.gContext = gContext;
        this.supervisor = gContext.getSupervisor();
        this.totalHeapMemSize = gContext.getGConfiguration().getTotalHeapMemSize();
        this.totalOffheapMemSize = gContext.getGConfiguration().getTotalOffheapMemSize();
        long max = gContext.getGConfiguration().getUseOffheap() ? this.totalOffheapMemSize : this.totalHeapMemSize;
        this.totalMemSize = (long)((float)max * gContext.getGConfiguration().getTotalHeapRate());
        this.totalMemLowMark = (long)((float)this.totalMemSize * gContext.getGConfiguration().getTotalHeapLowMarkRate());
        this.totalMemMiddleMark = (long)((float)this.totalMemSize * gContext.getGConfiguration().getTotalHeapMiddleMarkRate());
        this.totalMemHighMark = (long)((float)this.totalMemSize * gContext.getGConfiguration().getTotalHeapHighMarkRate());
        this.totalIndexCountHighMark = gContext.getGConfiguration().getTotalIndexCountHighMark();
        this.totalIndexCountLowMark = gContext.getGConfiguration().getTotalIndexCountLowMark();
        String prefix = gContext.getGConfiguration().getExcetorPrefixName();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat(prefix + "GeminiCacheManagerImpl-%d").build();
        this.cacheManagerExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(Short.MAX_VALUE), namedThreadFactory);
        int configReadPageCacheLRUSize = Math.min(20000, gContext.getGConfiguration().getTotalReadPageLRUNum());
        this.readPageCacheLRUSize = gContext.getGConfiguration().getUseOffheap() || gContext.getGConfiguration().getForceReadUseOffheap() ? Math.max(128, configReadPageCacheLRUSize) : configReadPageCacheLRUSize;
        this.evictPolicy = new EvictPolicySepImpl(this.gContext, this);
        LOG.info("CacheManagerImpl{}, offheap={}, maxHeapSize={}, maxDirectMemorySize={}, totalMemSize={},lowMark={},MiddleMark={},HighMark={},indexLowMark={},indexHighMark={}, dbSlots={}, readPageCacheLRUSize={}, checksumEnable={}", new Object[]{this, gContext.getGConfiguration().getUseOffheap(), this.totalHeapMemSize, this.totalOffheapMemSize, this.totalMemSize, this.totalMemLowMark, this.totalMemMiddleMark, this.totalMemHighMark, this.totalIndexCountLowMark, this.totalIndexCountHighMark, gContext.getGConfiguration().getDBNumberPerJVM(), this.readPageCacheLRUSize, gContext.getGConfiguration().isChecksumEnable()});
    }

    @Override
    public void start() {
        this.cacheManagerExecutor.submit(this.evictPolicy);
        if (this.gContext.getCacheMetric() != null) {
            this.gContext.getCacheMetric().getMetricGroup().gauge("totalMemHighMark", () -> this.totalMemHighMark);
            this.gContext.getCacheMetric().getMetricGroup().gauge("totalMemMiddleMark", () -> this.totalMemMiddleMark);
            this.gContext.getCacheMetric().getMetricGroup().gauge("totalMemLowMark", () -> this.totalMemLowMark);
            this.gContext.getCacheMetric().registerMetricsCacheStat(this.cacheStats);
        }
        LOG.info("CacheManager is initialized.");
    }

    @Override
    public void addIndexCapacity(int indexCapacity) {
        this.cacheStats.addIndexCapacity(indexCapacity);
    }

    @Override
    public long getPageUsedMemory() {
        return this.cacheStats.getTotalPageUsedMemory();
    }

    @Override
    public boolean forbidIndexExpand() {
        return this.cacheStats.getTotalIndexCapacity() >= this.totalIndexCountHighMark * 2L;
    }

    @Override
    public WaterMark getIndexCapacityWaterMark() {
        if (this.cacheStats.getTotalIndexCapacity() >= this.totalIndexCountHighMark) {
            return WaterMark.High;
        }
        if (this.cacheStats.getTotalIndexCapacity() >= this.totalIndexCountLowMark) {
            return WaterMark.Low;
        }
        return WaterMark.Normal;
    }

    @Override
    public WaterMark getMemWaterMark(int addEstimatedSize) {
        if (this.cacheStats.getTotalPageUsedMemory() + (long)addEstimatedSize >= this.totalMemHighMark) {
            return WaterMark.High;
        }
        if (this.cacheStats.getTotalPageUsedMemory() + (long)addEstimatedSize >= this.totalMemMiddleMark) {
            return WaterMark.Middle;
        }
        if (this.cacheStats.getTotalPageUsedMemory() + (long)addEstimatedSize >= this.totalMemLowMark) {
            return WaterMark.Low;
        }
        return WaterMark.Normal;
    }

    @Override
    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    @Override
    public void close() {
        this.cacheManagerExecutor.shutdownNow();
    }

    @Override
    public void addTable(GTable gTable) {
    }

    @Override
    public EvictPolicy getEvictPolicy() {
        return this.evictPolicy;
    }

    @Override
    public void addRegionEventExecutor(EventExecutor regionEventExecutor) {
        this.evictPolicy.addRegionEventExecutor(regionEventExecutor);
    }

    @Override
    public long getTotalTargetEvictSize() {
        return this.cacheStats.getTotalLogicPageSize() < this.totalMemMiddleMark ? 1L : this.cacheStats.getTotalLogicPageSize() - this.totalMemMiddleMark;
    }

    @Override
    public long getMemLowMark() {
        return this.totalMemLowMark;
    }

    @Override
    public long getMemMidMark() {
        return this.totalMemMiddleMark;
    }

    @Override
    public long getMemHighMark() {
        return this.totalMemHighMark;
    }

    @Override
    public int getReadPageCacheLRUSize() {
        return this.readPageCacheLRUSize;
    }
}

