/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPageLRU<K, V>
extends LinkedHashMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DataPageLRU.class);
    private final long lruSize;
    private final DataPageLRUFuction<V> function;
    private volatile int totalSize = 0;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public DataPageLRU(long lruSize, DataPageLRUFuction<V> function) {
        this.lruSize = lruSize;
        this.function = function;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V result;
        this.lock.writeLock().lock();
        try {
            result = super.put(key, value);
            this.totalSize += this.function.size(value);
            if (result != null) {
                this.totalSize -= this.function.size(result);
                this.function.removed(result);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    @Override
    public V get(Object key) {
        this.lock.readLock().lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if ((long)this.size() > this.lruSize) {
            this.totalSize -= this.function.size(eldest.getValue());
            this.function.removed(eldest.getValue());
            return true;
        }
        return super.removeEldestEntry(eldest);
    }

    public static interface DataPageLRUFuction<T> {
        public int size(T var1);

        public void removed(T var1);
    }
}

