/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiShutDownException;
import org.apache.flink.runtime.state.gemini.engine.handler.EvictHandlerSepImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;
import org.apache.flink.runtime.state.gemini.engine.vm.CacheManager;
import org.apache.flink.runtime.state.gemini.engine.vm.EvictPolicy;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvictPolicySepImpl
implements EvictPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(EvictPolicySepImpl.class);
    private final CacheManager cacheManager;
    private final GContext gContext;
    private final Map<EventExecutor, EvictHandlerSepImpl> evictHandlerMap = new HashMap<EventExecutor, EvictHandlerSepImpl>();
    private final Object printObject = new Object();
    private final long loopInterval = 1000L;
    private final int printTick = 10;

    public EvictPolicySepImpl(GContext gContext, CacheManager cacheManager) {
        this.gContext = gContext;
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int tick = 0;
        while (this.gContext.isDBNormal()) {
            try {
                Map.Entry<GByteBuffer, Object> gByteBuffer;
                Iterator<Map.Entry<GByteBuffer, Object>> iteratorDiscard = this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().getDiscardedPageHaveReferenceMonitor().entrySet().iterator();
                while (iteratorDiscard.hasNext()) {
                    Map.Entry<GByteBuffer, Object> gByteBuffer2 = iteratorDiscard.next();
                    if (gByteBuffer2.getKey().getCnt() > 0) continue;
                    iteratorDiscard.remove();
                    this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().addWaitSafeQueue(ReferenceCount.ReleaseType.Discard, gByteBuffer2.getKey());
                }
                Iterator<Map.Entry<GByteBuffer, Object>> iteratorEvict = this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().getEvictedPageHaveReferenceMonitor().entrySet().iterator();
                while (iteratorEvict.hasNext()) {
                    gByteBuffer = iteratorEvict.next();
                    if (gByteBuffer.getKey().getCnt() > 0) continue;
                    iteratorEvict.remove();
                    this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().addWaitSafeQueue(ReferenceCount.ReleaseType.Evict, (GByteBuffer)gByteBuffer.getKey());
                }
                while ((gByteBuffer = this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().getGByteBufferFromWaitQueue()) != null) {
                    if (gByteBuffer.getCnt() > 0) {
                        this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().addMonitorPageStillHaveReference((GByteBuffer)((Object)gByteBuffer), ReferenceCount.ReleaseType.Discard, "safeQueue");
                        continue;
                    }
                    if (gByteBuffer.getSeqID() == this.gContext.getAccessNumber()) break;
                    gByteBuffer.doFree();
                }
                if (tick++ >= 10) {
                    this.evictHandlerMap.values().forEach(handler -> LOG.info("Thread Mem WM {}", handler));
                    LOG.info("Mem WM:{}, Index WM:{}  {}  {}  ReadPageLRUSize={}/{} fileSize={}/{} Allocator1={} Allocator2={} discardMonitorSetSize={} evictMonitorSetSize={} TotalWaitQueueSize={}", new Object[]{this.cacheManager.getMemWaterMark(0), this.cacheManager.getIndexCapacityWaterMark(), this.cacheManager.getCacheStats(), this.gContext.getSupervisor().getWriteBufferManager(), this.gContext.getSupervisor().getFetchPolicy().getDataPageLRU().getTotalSize(), this.gContext.getSupervisor().getFetchPolicy().getDataPageLRU().size(), this.gContext.getSupervisor().getFileCache().getFileCacheStat().totalLocalWriteSize, this.gContext.getSupervisor().getFileCache().getFileCacheStat().totalLocalOriDataSize, this.gContext.getSupervisor().getAllocator(), this.gContext.getSupervisor().getForReadAllocator(), this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().getDiscardedPageHaveReferenceMonitor().size(), this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().getEvictedPageHaveReferenceMonitor().size(), this.gContext.getSupervisor().getDiscardOrEvictPageReleaseManager().getTotalWaitQueueSize()});
                    tick = 0;
                }
                Object object = this.printObject;
                synchronized (object) {
                    this.printObject.wait(1000L);
                }
            }
            catch (GeminiShutDownException ie) {
                LOG.debug("DB is in abnormal status " + this.gContext.getDBStatus().name());
            }
            catch (Exception e) {
                LOG.error("EvictPolicy has Exception={}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public void removeInvalidPage(GRegion gRegion, int curIndex, int relatedIndex, List<PageAddress> pageAddressList) {
        this.evictHandlerMap.get(gRegion.getExecutor()).removeInvalidPage(gRegion, curIndex, relatedIndex, pageAddressList);
    }

    @Override
    public void addEvictablePage(GRegion gRegion, PageAddress pageAddress) {
        this.evictHandlerMap.get(gRegion.getExecutor()).addEvictablePage(pageAddress, gRegion);
    }

    @Override
    public void addPageUsedMemory(GRegion gRegion, EventExecutor regionEventExecutor, int logicPageSize, boolean needEvict) {
        this.evictHandlerMap.get(regionEventExecutor).addPageUsedMemory(gRegion, logicPageSize, needEvict);
    }

    @Override
    public void addRegionEventExecutor(EventExecutor regionEventExecutor) {
        this.evictHandlerMap.putIfAbsent(regionEventExecutor, new EvictHandlerSepImpl(regionEventExecutor.toString(), this.gContext));
    }
}

