/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;

public class FutureDataPage {
    private final int size;
    private final CompletableFuture<DataPage> dataPageCompletedFuture;
    private volatile boolean removed = false;

    public FutureDataPage(int size) {
        this.size = size;
        this.dataPageCompletedFuture = new CompletableFuture();
    }

    public FutureDataPage(DataPage dataPage) {
        this.size = dataPage.getSize();
        this.dataPageCompletedFuture = CompletableFuture.completedFuture(dataPage);
    }

    public int getSize() {
        return this.size;
    }

    public boolean complete(DataPage dataPage) {
        boolean result = this.dataPageCompletedFuture.complete(dataPage);
        if (result && this.removed) {
            dataPage.delReferenceCount(ReferenceCount.ReleaseType.Normal);
        }
        return result;
    }

    public void completeExceptionally(Throwable throwable) {
        this.dataPageCompletedFuture.completeExceptionally(throwable);
    }

    public DataPage get() {
        try {
            return this.dataPageCompletedFuture.get();
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("FutureDataPage error:" + e.getMessage(), e);
        }
    }

    public DataPage get(int timeout) {
        try {
            return this.dataPageCompletedFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("FutureDataPage error, Msg=" + e.getMessage() + " ,cause=" + e.getClass().getSimpleName(), e);
        }
    }

    public boolean isFail() {
        return this.dataPageCompletedFuture.isCompletedExceptionally();
    }

    public boolean isDone() {
        return this.dataPageCompletedFuture.isDone();
    }

    public void removed() {
        this.removed = true;
        if (this.isDone() && !this.isFail()) {
            try {
                DataPage dataPage = this.dataPageCompletedFuture.get();
                dataPage.delReferenceCount(ReferenceCount.ReleaseType.Normal);
            }
            catch (Exception e) {
                throw new GeminiRuntimeException(e);
            }
        }
    }
}

