/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.internal;

import org.apache.flink.runtime.state.IncrementalStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;
import org.apache.flink.runtime.state.gemini.internal.DirectoryStreamStateHandle;
import org.apache.flink.util.Preconditions;

public abstract class AbstractGeminiKeyedStateHandle
implements KeyedStateHandle,
IncrementalStateHandle {
    private static final long serialVersionUID = -7957128385176716193L;
    protected final long checkpointId;
    protected final KeyGroupRange keyGroupRange;
    protected final StreamStateHandle metaStateHandle;
    protected final DirectoryStreamStateHandle dbSnapshotDirectoryHandle;
    protected final DBSnapshotMeta dbSnapshotMeta;

    public AbstractGeminiKeyedStateHandle(long checkpointId, KeyGroupRange keyGroupRange, StreamStateHandle metaStateHandle, DirectoryStreamStateHandle dbSnapshotDirectoryHandle, DBSnapshotMeta dbSnapshotMeta) {
        this.checkpointId = checkpointId;
        this.keyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange);
        this.metaStateHandle = (StreamStateHandle)Preconditions.checkNotNull((Object)metaStateHandle);
        this.dbSnapshotDirectoryHandle = (DirectoryStreamStateHandle)Preconditions.checkNotNull((Object)dbSnapshotDirectoryHandle);
        this.dbSnapshotMeta = (DBSnapshotMeta)Preconditions.checkNotNull((Object)dbSnapshotMeta);
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public StreamStateHandle getMetaStateHandle() {
        return this.metaStateHandle;
    }

    public DirectoryStreamStateHandle getDBSnapshotDirectoryHandle() {
        return this.dbSnapshotDirectoryHandle;
    }

    public DBSnapshotMeta getDBSnapshotMeta() {
        return this.dbSnapshotMeta;
    }

    @Override
    public long getStateSize() {
        return this.dbSnapshotMeta.getSnapshotMetaSize() + this.dbSnapshotMeta.getIncrementalSize();
    }

    @Override
    public long getFullStateSize() {
        return this.dbSnapshotMeta.getSnapshotMetaSize() + this.dbSnapshotMeta.getFullSize();
    }
}

