/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.keyed;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGTableKeyedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.runtime.state.keyed.AbstractKeyedMapState;
import org.apache.flink.util.Preconditions;

public abstract class AbstractGeminiKeyedMapStateImpl<K, MK, MV, M extends Map<MK, MV>>
implements AbstractKeyedMapState<K, MK, MV, M> {
    private final AbstractGTableKeyedMapImpl<K, MK, MV> table;

    public AbstractGeminiKeyedMapStateImpl(AbstractGTableKeyedMapImpl<K, MK, MV> table) {
        this.table = (AbstractGTableKeyedMapImpl)Preconditions.checkNotNull(table);
    }

    @Override
    public boolean contains(K key) {
        if (key == null) {
            return false;
        }
        return this.getRegion(key).contains(key);
    }

    @Override
    public boolean contains(K key, MK mapKey) {
        if (key == null || mapKey == null) {
            return false;
        }
        return this.getRegion(key).contains(key, mapKey);
    }

    @Override
    public M get(K key) {
        return this.getOrDefault(key, (M)null);
    }

    @Override
    public M getOrDefault(K key, M defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Map result = this.getRegion(key).getOrDefault(key, null);
        return (M)(result == null ? defaultValue : result);
    }

    @Override
    public MV get(K key, MK mapKey) {
        return this.getOrDefault(key, mapKey, null);
    }

    @Override
    public MV getOrDefault(K key, MK mapKey, MV defaultMapValue) {
        if (key == null || mapKey == null) {
            return defaultMapValue;
        }
        return this.getRegion(key).getOrDefault(key, mapKey, defaultMapValue);
    }

    @Override
    public Map<K, M> getAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return new HashMap();
        }
        HashMap<K, Object> results = new HashMap<K, Object>();
        for (K key : keys) {
            Object result;
            if (key == null || (result = this.get((Object)key)) == null || result.isEmpty()) continue;
            results.put(key, result);
        }
        return results;
    }

    @Override
    public M getAll(K key, Collection<? extends MK> mapKeys) {
        if (key == null || mapKeys == null || mapKeys.isEmpty()) {
            return this.createMap();
        }
        M results = this.createMap();
        for (MK mapKey : mapKeys) {
            MV value;
            if (mapKey == null || (value = this.get(key, mapKey)) == null) continue;
            results.put(mapKey, value);
        }
        return results;
    }

    @Override
    public Map<K, M> getAll(Map<K, ? extends Collection<? extends MK>> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, M> results = new HashMap<K, M>();
        for (Map.Entry<K, Collection<MK>> entry : map.entrySet()) {
            Collection<? extends MK> mapKeys;
            K key = entry.getKey();
            M resultMap = this.getAll(key, mapKeys = entry.getValue());
            if (resultMap.isEmpty()) continue;
            results.put(key, this.getAll(key, mapKeys));
        }
        return results;
    }

    @Override
    public void add(K key, MK mapKey, MV mapValue) {
        Preconditions.checkNotNull(key);
        this.getRegion(key).add(key, mapKey, mapValue);
    }

    @Override
    public void addAll(K key, Map<? extends MK, ? extends MV> mappings) {
        Preconditions.checkNotNull(key);
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        this.getRegion(key).addAll(key, mappings);
    }

    @Override
    public void addAll(Map<? extends K, ? extends Map<? extends MK, ? extends MV>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Map<MK, MV>> entry : map.entrySet()) {
            this.addAll(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            return;
        }
        this.getRegion(key).remove(key);
    }

    @Override
    public void remove(K key, MK mapKey) {
        if (key == null) {
            return;
        }
        this.getRegion(key).remove(key, mapKey);
    }

    @Override
    public void removeAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (K key : keys) {
            this.remove(key);
        }
    }

    @Override
    public void removeAll(K key, Collection<? extends MK> mapKeys) {
        if (key == null || mapKeys == null || mapKeys.isEmpty()) {
            return;
        }
        for (MK mapKey : mapKeys) {
            if (mapKey == null) continue;
            this.remove(key, mapKey);
        }
    }

    @Override
    public void removeAll(Map<? extends K, ? extends Collection<? extends MK>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Collection<MK>> entry : map.entrySet()) {
            this.removeAll(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> iterator(K key) {
        Preconditions.checkNotNull(key);
        Map res = (Map)this.getRegion(key).get(key);
        if (res == null) {
            return Collections.emptyIterator();
        }
        return res.entrySet().iterator();
    }

    @Override
    public Iterable<Map.Entry<MK, MV>> entries(K key) {
        Preconditions.checkNotNull(key);
        Map res = (Map)this.getRegion(key).get(key);
        if (res == null) {
            return Collections.emptySet();
        }
        return res.entrySet();
    }

    @Override
    public Iterable<MK> mapKeys(K key) {
        Preconditions.checkNotNull(key);
        Map res = (Map)this.getRegion(key).get(key);
        if (res == null) {
            return Collections.emptySet();
        }
        return res.keySet();
    }

    @Override
    public Iterable<MV> mapValues(K key) {
        Preconditions.checkNotNull(key);
        Map res = (Map)this.getRegion(key).get(key);
        if (res == null) {
            return Collections.emptySet();
        }
        return res.values();
    }

    @Override
    public Map<K, M> getAll() {
        HashMap results = new HashMap();
        Iterator<GRegion> iterator = this.table.regionIterator();
        while (iterator.hasNext()) {
            GRegionKMapImpl region = (GRegionKMapImpl)iterator.next();
            region.getAll(results);
        }
        return results;
    }

    @Override
    public void removeAll() {
        Iterator<GRegion> iterator = this.table.regionIterator();
        while (iterator.hasNext()) {
            GRegionKMapImpl region = (GRegionKMapImpl)iterator.next();
            region.removeAll();
        }
    }

    @Override
    public Iterable<K> keys() {
        return this.getAll().keySet();
    }

    @Override
    public StateStorage<K, M> getStateStorage() {
        throw new UnsupportedOperationException();
    }

    protected AbstractGRegionKMapImpl<K, MK, MV, ? extends Map<MK, MV>> getRegion(K key) {
        return (AbstractGRegionKMapImpl)this.table.getRegion(key);
    }

    abstract M createMap();
}

