/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.keyed;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKListImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableKeyedListImpl;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class GeminiKeyedListStateImpl<K, E>
implements KeyedListState<K, E> {
    private final KeyedListStateDescriptor<K, E> descriptor;
    private final GTableKeyedListImpl<K, E> table;

    public GeminiKeyedListStateImpl(KeyedListStateDescriptor<K, E> descriptor, GTableKeyedListImpl<K, E> table) {
        this.descriptor = (KeyedListStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.table = (GTableKeyedListImpl)Preconditions.checkNotNull(table);
    }

    @Override
    public KeyedListStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean contains(K key) {
        List<E> list = this.getOrDefault(key, null);
        return list != null;
    }

    @Override
    public List<E> get(K key) {
        return this.getOrDefault(key, null);
    }

    @Override
    public List<E> getOrDefault(K key, List<E> defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Object result = this.getRegion(key).get((Object)key);
        return result == null ? defaultValue : result;
    }

    @Override
    public Map<K, List<E>> getAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, Object> results = new HashMap<K, Object>();
        for (K key : keys) {
            Object result;
            if (key == null || (result = this.get((Object)key)) == null || result.isEmpty()) continue;
            results.put(key, result);
        }
        return results;
    }

    @Override
    public void add(K key, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(element, (String)"You can not add null value to list state.");
        this.getRegion(key).add(key, element);
    }

    @Override
    public void addAll(K key, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(elements, (String)"List of values to add cannot be null.");
        if (elements.isEmpty()) {
            return;
        }
        this.getRegion(key).addAll(key, elements);
    }

    @Override
    public void addAll(Map<? extends K, ? extends Collection<? extends E>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
            this.addAll(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(K key, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(element, (String)"You can not add null value to list state.");
        this.getRegion(key).put(key, (List<Object>)new ArrayList<Object>(Arrays.asList(element)));
    }

    @Override
    public void putAll(K key, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            Preconditions.checkNotNull(element, (String)"You cannot add null to a ListState.");
            list.add(element);
        }
        this.getRegion(key).put(key, list);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<? extends E>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
            this.putAll(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            return;
        }
        this.getRegion(key).remove(key);
    }

    @Override
    public boolean remove(K key, E elementToRemove) {
        if (key == null) {
            return false;
        }
        this.getRegion(key).remove(key, elementToRemove);
        return true;
    }

    @Override
    public void removeAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (K key : keys) {
            this.remove(key);
        }
    }

    @Override
    public boolean removeAll(K key, Collection<? extends E> elementsToRemove) {
        if (key == null) {
            return false;
        }
        this.getRegion(key).removeAll(key, elementsToRemove);
        return true;
    }

    @Override
    public boolean removeAll(Map<? extends K, ? extends Collection<? extends E>> map) {
        if (map == null || map.isEmpty()) {
            return false;
        }
        boolean success = false;
        for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
            Collection<? extends E> elements;
            K key = entry.getKey();
            success = this.removeAll(key, elements = entry.getValue()) || success;
        }
        return success;
    }

    @Override
    public Map<K, List<E>> getAll() {
        HashMap results = new HashMap();
        Iterator<GRegion> iterator = this.table.regionIterator();
        while (iterator.hasNext()) {
            GRegionKListImpl region = (GRegionKListImpl)iterator.next();
            region.getAll(results);
        }
        return results;
    }

    @Override
    public void removeAll() {
        Iterator<GRegion> iterator = this.table.regionIterator();
        while (iterator.hasNext()) {
            GRegionKListImpl region = (GRegionKListImpl)iterator.next();
            region.removeAll();
        }
    }

    @Override
    public Iterable<K> keys() {
        return this.getAll().keySet();
    }

    @Override
    public E poll(K key) {
        return this.getRegion(key).poll(key);
    }

    @Override
    public E peek(K key) {
        return this.getRegion(key).peek(key);
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<List<E>> safeValueSerializer) throws Exception {
        Object key = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, (TypeSerializer)VoidNamespaceSerializer.INSTANCE).f0;
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        TypeSerializer<E> dupSerializer = this.descriptor.getElementSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        for (int i = 0; i < value.size(); ++i) {
            dupSerializer.serialize(value.get(i), (DataOutputView)view);
            if (i >= value.size() - 1) continue;
            view.writeByte(44);
        }
        view.flush();
        return baos.toByteArray();
    }

    @Override
    public StateStorage<K, List<E>> getStateStorage() {
        throw new UnsupportedOperationException();
    }

    private GRegionKListImpl<K, E> getRegion(K key) {
        return (GRegionKListImpl)this.table.getRegion(key);
    }
}

