/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.keyed;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKVImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableOneKeyImpl;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class GeminiKeyedValueStateImpl<K, V>
implements KeyedValueState<K, V> {
    private final KeyedValueStateDescriptor<K, V> descriptor;
    private final GTableOneKeyImpl<K, V> table;

    public GeminiKeyedValueStateImpl(KeyedValueStateDescriptor<K, V> descriptor, GTableOneKeyImpl<K, V> table) {
        this.descriptor = (KeyedValueStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.table = (GTableOneKeyImpl)Preconditions.checkNotNull(table);
    }

    @Override
    public KeyedValueStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean contains(K key) {
        return this.get(key) != null;
    }

    @Override
    public V get(K key) {
        return this.getOrDefault(key, null);
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        V value = this.getRegion(key).get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> results = new HashMap<K, V>();
        for (K key : keys) {
            V value;
            if (key == null || (value = this.get(key)) == null) continue;
            results.put(key, value);
        }
        return results;
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            return;
        }
        this.getRegion(key).remove(key);
    }

    @Override
    public void removeAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (K key : keys) {
            this.remove(key);
        }
    }

    @Override
    public void put(K key, V value) {
        Preconditions.checkNotNull(key);
        this.getRegion(key).put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> entry : pairs.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<K, V> getAll() {
        HashMap results = new HashMap();
        Iterator<GRegion> iterator = this.table.regionIterator();
        while (iterator.hasNext()) {
            GRegionKVImpl region = (GRegionKVImpl)iterator.next();
            region.getAll(results);
        }
        return results;
    }

    @Override
    public void removeAll() {
        Iterator<GRegion> iterator = this.table.regionIterator();
        while (iterator.hasNext()) {
            GRegionKVImpl region = (GRegionKVImpl)iterator.next();
            region.removeAll();
        }
    }

    @Override
    public Iterable<K> keys() {
        return this.getAll().keySet();
    }

    @Override
    public <T> void transform(K key, T value, StateTransformationFunction<V, T> transformation) {
        try {
            V oldValue = this.get(key);
            V newValue = transformation.apply(oldValue, value);
            this.put(key, newValue);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        Object key = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, (TypeSerializer)VoidNamespaceSerializer.INSTANCE).f0;
        V value = this.get(key);
        if (value == null) {
            return null;
        }
        return KvStateSerializer.serializeValue(value, this.descriptor.getValueSerializer());
    }

    @Override
    public StateStorage<K, V> getStateStorage() {
        throw new UnsupportedOperationException();
    }

    private GRegionKVImpl<K, V> getRegion(K key) {
        return this.table.getRegion((Object)key);
    }
}

