/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.subkeyed;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.HashPartitioner;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GeminiPKey2;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGTableSubKeyedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.runtime.state.subkeyed.AbstractSubKeyedMapState;
import org.apache.flink.util.Preconditions;

abstract class AbstractGeminiSubKeyedMapStateImpl<K, N, MK, MV, M extends Map<MK, MV>>
implements AbstractSubKeyedMapState<K, N, MK, MV, M> {
    protected final AbstractGTableSubKeyedMapImpl<K, N, MK, MV> table;
    private final Byte dummyByte = new Byte(0);
    protected TypeSerializer<K> keySerializer;
    protected TypeSerializer<MK> mapKeySerializer;
    protected TypeSerializer<MV> mapValueSerializer;
    protected TypeSerializer<N> namespaceSerializer;
    private final Map<MK, MV> emptyMap = new HashMap<MK, MV>(0);
    protected ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
    protected DataOutputView outputView = new DataOutputViewStreamWrapper((OutputStream)this.outputStream);
    protected final HashPartitioner partitioner = HashPartitioner.INSTANCE;

    AbstractGeminiSubKeyedMapStateImpl(AbstractGTableSubKeyedMapImpl<K, N, MK, MV> table) {
        this.table = (AbstractGTableSubKeyedMapImpl)Preconditions.checkNotNull(table);
    }

    abstract M createMap();

    @Override
    public boolean contains(K key, N namespace, MK mapKey) {
        if (key == null || namespace == null) {
            return false;
        }
        try {
            return this.getRegion(key, namespace).contains(this.table.getGeminiPKey2(key, namespace), mapKey);
        }
        catch (Exception e) {
            throw new StateAccessException(e.getCause());
        }
    }

    @Override
    public boolean contains(K key, N namespace) {
        if (key == null || namespace == null) {
            return false;
        }
        try {
            return this.getRegion(key, namespace).contains(this.table.getGeminiPKey2(key, namespace));
        }
        catch (Exception e) {
            throw new StateAccessException(e.getCause());
        }
    }

    @Override
    public MV get(K key, N namespace, MK mapKey) {
        return this.getOrDefault(key, namespace, mapKey, null);
    }

    @Override
    public MV getOrDefault(K key, N namespace, MK mapKey, MV defaultMapValue) {
        if (key == null || namespace == null) {
            return defaultMapValue;
        }
        MV result = this.getRegion(key, namespace).get(this.table.getGeminiPKey2(key, namespace), mapKey);
        if (result == null) {
            result = defaultMapValue;
        }
        return result;
    }

    @Override
    public M get(K key, N namespace) {
        return this.getOrDefault(key, namespace, (M)null);
    }

    @Override
    public M getOrDefault(K key, N namespace, M defaultMap) {
        if (key == null || namespace == null) {
            return defaultMap;
        }
        Map result = (Map)this.getRegion(key, namespace).get(this.table.getGeminiPKey2(key, namespace));
        return (M)(result == null || result.isEmpty() ? defaultMap : result);
    }

    @Override
    public M getAll(K key, N namespace, Collection<? extends MK> mapKeys) {
        if (key == null || namespace == null || mapKeys == null || mapKeys.isEmpty()) {
            return null;
        }
        M result = this.createMap();
        for (MK mapKey : mapKeys) {
            MV value;
            if (mapKey == null || (value = this.get(key, namespace, mapKey)) == null) continue;
            result.put(mapKey, value);
        }
        return result.isEmpty() ? null : (M)result;
    }

    @Override
    public Map<N, M> getAll(K key) {
        if (key == null) {
            return Collections.emptyMap();
        }
        Iterator<N> namespaceIter = this.table.getSecondaryKeyByFirstKey(key);
        HashMap<N, Object> result = new HashMap<N, Object>();
        HashSet<N> visitedNamespace = new HashSet<N>();
        while (namespaceIter.hasNext()) {
            N namespace = namespaceIter.next();
            if (visitedNamespace.contains(namespace)) continue;
            Object innerMap = this.get((Object)key, (Object)namespace);
            visitedNamespace.add(namespace);
            if (innerMap == null) continue;
            result.put(namespace, this.get((Object)key, (Object)namespace));
        }
        return result;
    }

    @Override
    public void add(K key, N namespace, MK mapKey, MV mapValue) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(mapKey);
        Preconditions.checkNotNull(mapValue);
        this.getRegion(key, namespace).add(this.table.getGeminiPKey2(key, namespace), mapKey, mapValue);
        this.getIndexRegion(key).add(key, namespace, this.dummyByte);
    }

    @Override
    public void addAll(K key, N namespace, Map<? extends MK, ? extends MV> mappings) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        this.getRegion(key, namespace).addAll(this.table.getGeminiPKey2(key, namespace), mappings);
        this.getIndexRegion(key).add(key, namespace, this.dummyByte);
    }

    @Override
    public void remove(K key, N namespace) {
        if (key == null || namespace == null) {
            return;
        }
        this.getRegion(key, namespace).remove(this.table.getGeminiPKey2(key, namespace));
        this.getIndexRegion(key).remove(key, namespace);
    }

    @Override
    public void remove(K key, N namespace, MK mapKey) {
        if (key == null || namespace == null) {
            return;
        }
        this.getRegion(key, namespace).remove(this.table.getGeminiPKey2(key, namespace), mapKey);
    }

    @Override
    public void removeAll(K key, N namespace, Collection<? extends MK> mapKeys) {
        if (key == null || namespace == null || mapKeys.isEmpty()) {
            return;
        }
        for (MK mapKey : mapKeys) {
            this.remove(key, namespace, mapKey);
        }
    }

    @Override
    public void removeAll(K key) {
        if (key == null) {
            return;
        }
        Iterator<N> iterator = this.table.getSecondaryKeyByFirstKey(key);
        while (iterator.hasNext()) {
            this.remove(key, iterator.next());
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> iterator(K key, N namespace) {
        Preconditions.checkNotNull(key);
        return ((Map)this.getRegion(key, namespace).get(this.table.getGeminiPKey2(key, namespace))).entrySet().iterator();
    }

    @Override
    public Iterable<Map.Entry<MK, MV>> entries(K key, N namespace) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Map values = (Map)this.getRegion(key, namespace).get(this.table.getGeminiPKey2(key, namespace));
        return values == null ? this.emptyMap.entrySet() : values.entrySet();
    }

    @Override
    public Iterable<MK> keys(K key, N namespace) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Map result = (Map)this.getRegion(key, namespace).get(this.table.getGeminiPKey2(key, namespace));
        return result == null ? this.emptyMap.keySet() : result.keySet();
    }

    @Override
    public Iterable<MV> values(K key, N namespace) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Map result = (Map)this.getRegion(key, namespace).get(this.table.getGeminiPKey2(key, namespace));
        return result == null ? this.emptyMap.values() : result.values();
    }

    @Override
    public Iterator<N> iterator(final K key) {
        Preconditions.checkNotNull(key);
        final Iterator<N> namespaceIter = this.table.getSecondaryKeyByFirstKey(key);
        return new Iterator<N>(){
            N nextNamespace = null;
            N lastNamespace = null;

            @Override
            public boolean hasNext() {
                while (this.nextNamespace == null && namespaceIter.hasNext()) {
                    this.nextNamespace = namespaceIter.next();
                    if (AbstractGeminiSubKeyedMapStateImpl.this.contains(key, this.nextNamespace)) continue;
                    this.nextNamespace = null;
                }
                return this.nextNamespace != null;
            }

            @Override
            public N next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastNamespace = this.nextNamespace;
                this.nextNamespace = null;
                return this.lastNamespace;
            }

            @Override
            public void remove() {
                AbstractGeminiSubKeyedMapStateImpl.this.remove(key, this.lastNamespace);
            }
        };
    }

    @Override
    public Iterable<K> keys(N namespace) {
        Iterator<GRegion> iterator = this.table.regionIterator();
        HashSet result = new HashSet();
        while (iterator.hasNext()) {
            AbstractGRegionKMapImpl cur = (AbstractGRegionKMapImpl)iterator.next();
            result.addAll(cur.getAll().entrySet().stream().map(a -> (GeminiPKey2)a.getKey()).filter(x -> namespace.equals(x.getSecondKey())).map(y -> y.getFirstKey()).collect(Collectors.toSet()));
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<M> safeValueSerializer) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected AbstractGRegionKMapImpl<GeminiPKey2<K, N>, MK, MV, ? extends Map<MK, MV>> getRegion(K key, N namespace) {
        return (AbstractGRegionKMapImpl)this.table.getRegion(this.table.getGeminiPKey2(key, namespace));
    }

    protected GRegionKMapImpl<K, N, Byte> getIndexRegion(K key) {
        return this.table.getIndexRegion(key);
    }
}

