/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.subkeyed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GeminiPKey2;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKListImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableSubKeyedListImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class GeminiSubKeyedListStateImpl<K, N, E>
implements SubKeyedListState<K, N, E> {
    private final SubKeyedListStateDescriptor<K, N, E> descriptor;
    private final GTableSubKeyedListImpl<K, N, E> table;
    private final Byte dummyByte = new Byte(0);

    public GeminiSubKeyedListStateImpl(SubKeyedListStateDescriptor<K, N, E> descriptor, GTableSubKeyedListImpl<K, N, E> table) {
        this.table = (GTableSubKeyedListImpl)Preconditions.checkNotNull(table);
        this.descriptor = (SubKeyedListStateDescriptor)Preconditions.checkNotNull(descriptor);
    }

    @Override
    public SubKeyedListStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean contains(K key, N namespace) {
        if (key == null || namespace == null) {
            return false;
        }
        return this.getRegion(key, namespace).contains(this.table.getGeminiPKey2(key, namespace));
    }

    @Override
    public List<E> get(K key, N namespace) {
        return this.getOrDefault(key, namespace, null);
    }

    @Override
    public List<E> getOrDefault(K key, N namespace, List<E> defaultList) {
        if (key == null || namespace == null) {
            return defaultList;
        }
        return this.getRegion(key, namespace).getOrDefault(this.table.getGeminiPKey2(key, namespace), defaultList);
    }

    @Override
    public Map<N, List<E>> getAll(K key) {
        if (key == null) {
            return Collections.emptyMap();
        }
        HashMap<N, Object> result = new HashMap<N, Object>();
        HashSet<N> visitedNamespace = new HashSet<N>();
        Iterator<N> namepsaceIter = this.table.getSecondaryKeyByFirstKey(key);
        while (namepsaceIter.hasNext()) {
            N namespace = namepsaceIter.next();
            if (visitedNamespace.contains(namespace)) continue;
            Object value = this.get((Object)key, (Object)namespace);
            visitedNamespace.add(namespace);
            result.put(namespace, value);
        }
        return result;
    }

    @Override
    public void add(K key, N namespace, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(element);
        this.getRegion(key, namespace).add(this.table.getGeminiPKey2(key, namespace), element);
        this.getIndexRegion(key, namespace).add(key, namespace, this.dummyByte);
    }

    @Override
    public void addAll(K key, N namespace, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(elements);
        if (elements.isEmpty()) {
            return;
        }
        this.getRegion(key, namespace).addAll(this.table.getGeminiPKey2(key, namespace), elements);
        this.getIndexRegion(key, namespace).add(key, namespace, this.dummyByte);
    }

    @Override
    public void put(K key, N namespace, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(element);
        this.getRegion(key, namespace).put(this.table.getGeminiPKey2(key, namespace), Arrays.asList(element));
        this.getIndexRegion(key, namespace).add(key, namespace, this.dummyByte);
    }

    @Override
    public void putAll(K key, N namespace, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(elements);
        if (elements.isEmpty()) {
            return;
        }
        this.getRegion(key, namespace).put(this.table.getGeminiPKey2(key, namespace), elements.stream().collect(Collectors.toList()));
        this.getIndexRegion(key, namespace).add(key, namespace, this.dummyByte);
    }

    @Override
    public void remove(K key, N namespace) {
        if (key == null || namespace == null) {
            return;
        }
        this.getRegion(key, namespace).remove(this.table.getGeminiPKey2(key, namespace));
        this.getIndexRegion(key, namespace).remove(key, namespace);
    }

    @Override
    public boolean remove(K key, N namespace, E elementToRemove) {
        if (key == null || namespace == null) {
            return false;
        }
        this.getRegion(key, namespace).remove(this.table.getGeminiPKey2(key, namespace), elementToRemove);
        return true;
    }

    @Override
    public boolean removeAll(K key, N namespace, Collection<? extends E> elements) {
        if (key == null || namespace == null || elements == null || elements.isEmpty()) {
            return false;
        }
        this.getRegion(key, namespace).removeAll(this.table.getGeminiPKey2(key, namespace), elements);
        return true;
    }

    @Override
    public void removeAll(K key) {
        if (key == null) {
            return;
        }
        Iterator<N> namespaceIter = this.table.getSecondaryKeyByFirstKey(key);
        while (namespaceIter.hasNext()) {
            N namespace = namespaceIter.next();
            this.remove(key, namespace);
        }
    }

    @Override
    public Iterator<N> iterator(final K key) {
        Preconditions.checkNotNull(key);
        final Iterator<N> namespaceIter = this.table.getSecondaryKeyByFirstKey(key);
        return new Iterator<N>(){
            N nextNamespace = null;
            N lastNamespace = null;

            @Override
            public boolean hasNext() {
                while (this.nextNamespace == null && namespaceIter.hasNext()) {
                    this.nextNamespace = namespaceIter.next();
                    if (GeminiSubKeyedListStateImpl.this.contains(key, this.nextNamespace)) continue;
                    this.nextNamespace = null;
                }
                return this.nextNamespace != null;
            }

            @Override
            public N next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastNamespace = this.nextNamespace;
                this.nextNamespace = null;
                return this.lastNamespace;
            }

            @Override
            public void remove() {
                GeminiSubKeyedListStateImpl.this.remove(key, this.lastNamespace);
            }
        };
    }

    @Override
    public StateStorage<K, List<E>> getStateStorage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll(K key, N namespace) {
        return this.getRegion(key, namespace).poll(this.table.getGeminiPKey2(key, namespace));
    }

    @Override
    public E peek(K key, N namespace) {
        return this.getRegion(key, namespace).peek(this.table.getGeminiPKey2(key, namespace));
    }

    @Override
    public Iterable<K> keys(N namespace) {
        Iterator<GRegion> iterator = this.table.regionIterator();
        HashSet result = new HashSet();
        while (iterator.hasNext()) {
            GRegionKListImpl cur = (GRegionKListImpl)iterator.next();
            result.addAll(cur.getAll().entrySet().stream().filter(m -> namespace.equals(((GeminiPKey2)m.getKey()).getSecondKey())).map(y -> ((GeminiPKey2)y.getKey()).getFirstKey()).collect(Collectors.toSet()));
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<List<E>> safeValueSerializer) {
        throw new UnsupportedOperationException();
    }

    private GRegionKListImpl<GeminiPKey2<K, N>, E> getRegion(K key, N namespace) {
        return this.table.getRegion(this.table.getGeminiPKey2(key, namespace));
    }

    private GRegionKMapImpl<K, N, Byte> getIndexRegion(K key, N namespace) {
        return this.table.getIndexRegion(this.table.getGeminiPKey2(key, namespace));
    }
}

