/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.subkeyed;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKSortedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableSubKeyedSortedMapImpl;
import org.apache.flink.runtime.state.gemini.subkeyed.AbstractGeminiSubKeyedMapStateImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapStateDescriptor;

public final class GeminiSubKeyedSortedMapStateImpl<K, N, MK, MV>
extends AbstractGeminiSubKeyedMapStateImpl<K, N, MK, MV, SortedMap<MK, MV>>
implements SubKeyedSortedMapState<K, N, MK, MV> {
    private SubKeyedSortedMapStateDescriptor stateDescriptor;

    public GeminiSubKeyedSortedMapStateImpl(SubKeyedSortedMapStateDescriptor<K, N, MK, MV> descriptor, GTableSubKeyedSortedMapImpl table) {
        super(table);
        this.stateDescriptor = descriptor;
    }

    @Override
    public SubKeyedSortedMapStateDescriptor getDescriptor() {
        return this.stateDescriptor;
    }

    @Override
    SortedMap<MK, MV> createMap() {
        Comparator comparator = this.stateDescriptor.getComparator();
        return new TreeMap(comparator);
    }

    @Override
    public StateStorage<K, SortedMap<MK, MV>> getStateStorage() {
        return null;
    }

    @Override
    public Map.Entry<MK, MV> firstEntry(K key, N namespace) {
        if (key == null || namespace == null) {
            return null;
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key, namespace);
        return region.firstEntry(this.table.getGeminiPKey2(key, namespace));
    }

    @Override
    public Map.Entry<MK, MV> lastEntry(K key, N namespace) {
        if (key == null || namespace == null) {
            return null;
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key, namespace);
        return region.lastEntry(this.table.getGeminiPKey2(key, namespace));
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> headIterator(K key, N namespace, MK endMapKey) {
        if (key == null || namespace == null || endMapKey == null) {
            return Collections.emptyIterator();
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key, namespace);
        return region.headIterator(this.table.getGeminiPKey2(key, namespace), endMapKey);
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> tailIterator(K key, N namespace, MK startMapKey) {
        if (key == null || namespace == null || startMapKey == null) {
            return Collections.emptyIterator();
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key, namespace);
        return region.tailIterator(this.table.getGeminiPKey2(key, namespace), startMapKey);
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> subIterator(K key, N namespace, MK startMapKey, MK endMapKey) {
        if (key == null || namespace == null || startMapKey == null || endMapKey == null) {
            return Collections.emptyIterator();
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key, namespace);
        return region.subIterator(this.table.getGeminiPKey2(key, namespace), startMapKey, endMapKey);
    }
}

