/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.subkeyed;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableSubKeyedValueImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class GeminiSubKeyedValueStateImpl<K, N, V>
implements SubKeyedValueState<K, N, V> {
    private final SubKeyedValueStateDescriptor descriptor;
    private final GTableSubKeyedValueImpl<K, N, V> table;

    public GeminiSubKeyedValueStateImpl(SubKeyedValueStateDescriptor descriptor, GTableSubKeyedValueImpl<K, N, V> table) {
        this.descriptor = (SubKeyedValueStateDescriptor)Preconditions.checkNotNull((Object)descriptor);
        this.table = (GTableSubKeyedValueImpl)Preconditions.checkNotNull(table);
    }

    @Override
    public SubKeyedValueStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean contains(K key, N namespace) {
        if (key == null || namespace == null) {
            return false;
        }
        return this.getRegion(key).contains(key, namespace);
    }

    @Override
    public V get(K key, N namespace) {
        return this.getOrDefault(key, namespace, null);
    }

    @Override
    public V getOrDefault(K key, N namespace, V defaultValue) {
        if (key == null || namespace == null) {
            return defaultValue;
        }
        return this.getRegion(key).getOrDefault(key, namespace, defaultValue);
    }

    @Override
    public Map<N, V> getAll(K key) {
        if (key == null) {
            return Collections.emptyMap();
        }
        Object result = this.getRegion(key).get((Object)key);
        return result == null ? Collections.emptyMap() : result;
    }

    @Override
    public void remove(K key, N namespace) {
        if (key == null || namespace == null) {
            return;
        }
        this.getRegion(key).remove(key, namespace);
    }

    @Override
    public void removeAll(K key) {
        if (key == null) {
            return;
        }
        this.getRegion(key).remove(key);
    }

    @Override
    public void put(K key, N namespace, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        this.getRegion(key).add(key, namespace, value);
    }

    @Override
    public V getAndRemove(K key, N namespace) {
        if (key == null || namespace == null) {
            return null;
        }
        V value = this.get(key, namespace);
        this.remove(key, namespace);
        return value;
    }

    @Override
    public Iterator<N> iterator(final K key) {
        Preconditions.checkNotNull(key);
        Object ret = this.getRegion(key).get((Object)key);
        if (ret == null) {
            return Collections.emptyIterator();
        }
        final Iterator namespaceIter = ret.keySet().iterator();
        return new Iterator<N>(){
            N currentNamespace = null;

            @Override
            public boolean hasNext() {
                return namespaceIter.hasNext();
            }

            @Override
            public N next() {
                this.currentNamespace = namespaceIter.next();
                return this.currentNamespace;
            }

            @Override
            public void remove() {
                GeminiSubKeyedValueStateImpl.this.remove(key, this.currentNamespace);
            }
        };
    }

    @Override
    public StateStorage<K, V> getStateStorage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void transform(K key, N namespace, T value, StateTransformationFunction<V, T> transformation) {
        V oldValue = this.get(key, namespace);
        try {
            V newValue = transformation.apply(oldValue, value);
            this.put(key, namespace, newValue);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterable<K> keys(N namespace) {
        Iterator<GRegion> iterator = this.table.regionIterator();
        HashSet result = new HashSet();
        while (iterator.hasNext()) {
            GRegionKMapImpl cur = (GRegionKMapImpl)iterator.next();
            result.addAll(cur.getAll().entrySet().stream().filter(a -> ((Map)a.getValue()).keySet().contains(namespace)).map(a -> a.getKey()).collect(Collectors.toSet()));
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        throw new UnsupportedOperationException();
    }

    private GRegionKMapImpl<K, N, V> getRegion(K key) {
        return this.table.getRegion((Object)key);
    }
}

