/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedStateBinder;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class KeyedListStateDescriptor<K, E>
extends KeyedStateDescriptor<K, List<E>, KeyedListState<K, E>> {
    private static final long serialVersionUID = 1L;

    public KeyedListStateDescriptor(String name, TypeSerializer<K> keySerializer, TypeSerializer<E> elementSerializer) {
        this(name, keySerializer, new ListSerializer(elementSerializer));
    }

    public KeyedListStateDescriptor(String name, TypeSerializer<K> keySerializer, ListSerializer<E> listSerializer) {
        super(name, InternalStateType.KEYED_LIST, keySerializer, listSerializer);
    }

    @Override
    public ListSerializer<E> getValueSerializer() {
        TypeSerializer listSerializer = super.getValueSerializer();
        Preconditions.checkState((boolean)(listSerializer instanceof ListSerializer));
        return (ListSerializer)listSerializer;
    }

    public TypeSerializer<E> getElementSerializer() {
        return this.getValueSerializer().getElementSerializer();
    }

    @Override
    public KeyedListState<K, E> bind(KeyedStateBinder stateBinder) throws Exception {
        return stateBinder.createKeyedListState(this);
    }
}

