/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedStateBinder;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.util.Preconditions;

public class KeyedMapStateDescriptor<K, MK, MV>
extends KeyedStateDescriptor<K, Map<MK, MV>, KeyedMapState<K, MK, MV>> {
    private static final long serialVersionUID = 1L;

    public KeyedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, TypeSerializer<MK> mapKeySerializer, TypeSerializer<MV> mapValueSerializer) {
        this(name, keySerializer, new MapSerializer(mapKeySerializer, mapValueSerializer));
    }

    public KeyedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, MapSerializer<MK, MV> mapSerializer) {
        super(name, InternalStateType.KEYED_MAP, keySerializer, mapSerializer);
    }

    public MapSerializer<MK, MV> getValueSerializer() {
        TypeSerializer mapSerializer = super.getValueSerializer();
        Preconditions.checkState((boolean)(mapSerializer instanceof MapSerializer));
        return (MapSerializer)mapSerializer;
    }

    public TypeSerializer<MK> getMapKeySerializer() {
        return this.getValueSerializer().getKeySerializer();
    }

    public TypeSerializer<MV> getMapValueSerializer() {
        return this.getValueSerializer().getValueSerializer();
    }

    @Override
    public KeyedMapState<K, MK, MV> bind(KeyedStateBinder stateBinder) throws Exception {
        return stateBinder.createKeyedMapState(this);
    }
}

