/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.util.SortedMap;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.SortedMapSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.runtime.state.keyed.KeyedStateBinder;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class KeyedSortedMapStateDescriptor<K, MK, MV>
extends KeyedStateDescriptor<K, SortedMap<MK, MV>, KeyedSortedMapState<K, MK, MV>> {
    private static final long serialVersionUID = 1L;

    public KeyedSortedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, Comparator<MK> mapComparator, TypeSerializer<MK> mapKeySerializer, TypeSerializer<MV> mapValueSerializer) {
        this(name, keySerializer, new SortedMapSerializer(mapComparator, mapKeySerializer, mapValueSerializer));
    }

    public KeyedSortedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, SortedMapSerializer<MK, MV> sortedMapSerializer) {
        super(name, InternalStateType.KEYED_SORTEDMAP, keySerializer, sortedMapSerializer);
    }

    public SortedMapSerializer<MK, MV> getValueSerializer() {
        TypeSerializer sortedMapSerializer = super.getValueSerializer();
        Preconditions.checkState((boolean)(sortedMapSerializer instanceof SortedMapSerializer));
        return (SortedMapSerializer)sortedMapSerializer;
    }

    public Comparator<MK> getMapKeyComparator() {
        return this.getValueSerializer().getComparator();
    }

    public TypeSerializer<MK> getMapKeySerializer() {
        SortedMapSerializer<MK, MV> sortedMapSerializer = this.getValueSerializer();
        return sortedMapSerializer.getKeySerializer();
    }

    public TypeSerializer<MV> getMapValueSerializer() {
        SortedMapSerializer<MK, MV> sortedMapSerializer = this.getValueSerializer();
        return sortedMapSerializer.getValueSerializer();
    }

    @Override
    public KeyedSortedMapState<K, MK, MV> bind(KeyedStateBinder stateBinder) throws Exception {
        return stateBinder.createKeyedSortedMapState(this);
    }
}

