/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateBinder;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.util.Preconditions;

public class SubKeyedMapStateDescriptor<K, N, MK, MV>
extends SubKeyedStateDescriptor<K, N, Map<MK, MV>, SubKeyedMapState<K, N, MK, MV>> {
    private static final long serialVersionUID = 1L;

    public SubKeyedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<MK> mapKeySerializer, TypeSerializer<MV> mapValueSerializer) {
        this(name, keySerializer, namespaceSerializer, new MapSerializer(mapKeySerializer, mapValueSerializer));
    }

    public SubKeyedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, MapSerializer<MK, MV> mapSerializer) {
        super(name, InternalStateType.SUBKEYED_MAP, keySerializer, namespaceSerializer, mapSerializer);
    }

    public MapSerializer<MK, MV> getValueSerializer() {
        TypeSerializer mapSerializer = super.getValueSerializer();
        Preconditions.checkState((boolean)(mapSerializer instanceof MapSerializer));
        return (MapSerializer)mapSerializer;
    }

    public TypeSerializer<MK> getMapKeySerializer() {
        return this.getValueSerializer().getKeySerializer();
    }

    public TypeSerializer<MV> getMapValueSerializer() {
        return this.getValueSerializer().getValueSerializer();
    }

    @Override
    public SubKeyedMapState<K, N, MK, MV> bind(SubKeyedStateBinder stateBinder) throws Exception {
        return stateBinder.createSubKeyedMapState(this);
    }
}

