/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateBinder;
import org.apache.flink.util.Preconditions;

public abstract class SubKeyedStateDescriptor<K, N, V, S extends SubKeyedState<K, N, V>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<N> namespaceSerializer;
    private final TypeSerializer<V> valueSerializer;
    private final InternalStateType stateType;

    public SubKeyedStateDescriptor(String name, InternalStateType stateType, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)stateType));
        Preconditions.checkNotNull(keySerializer);
        Preconditions.checkNotNull(namespaceSerializer);
        Preconditions.checkNotNull(valueSerializer);
        this.name = name;
        this.stateType = stateType;
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.valueSerializer = valueSerializer;
    }

    public abstract S bind(SubKeyedStateBinder var1) throws Exception;

    public String getName() {
        return this.name;
    }

    public InternalStateType getStateType() {
        return this.stateType;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubKeyedStateDescriptor that = (SubKeyedStateDescriptor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.keySerializer, that.keySerializer) && Objects.equals(this.namespaceSerializer, that.namespaceSerializer) && Objects.equals(this.valueSerializer, that.valueSerializer);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.keySerializer);
        result = 31 * result + Objects.hashCode(this.namespaceSerializer);
        result = 31 * result + Objects.hashCode(this.valueSerializer);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", keySerializer=" + this.keySerializer + ", namespaceSerializer=" + this.namespaceSerializer + ", valueSerializer=" + this.valueSerializer + "}";
    }
}

