/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.util.Preconditions;

public class SlotStatus
implements Serializable {
    private static final long serialVersionUID = 5099191707339664493L;
    private final SlotID slotID;
    private final ResourceProfile resourceProfile;
    private final AllocationID allocationID;
    private final ResourceProfile allocationResourceProfile;
    private final JobID jobID;
    private final List<SlotTag> tags;
    private final long version;

    public SlotStatus(SlotID slotID, ResourceProfile resourceProfile) {
        this(slotID, resourceProfile, null, null, null, Collections.emptyList(), 0L);
    }

    public SlotStatus(SlotID slotID, ResourceProfile resourceProfile, JobID jobID, AllocationID allocationID, ResourceProfile allocationResourceProfile, long version) {
        this(slotID, resourceProfile, jobID, allocationID, allocationResourceProfile, Collections.emptyList(), version);
    }

    public SlotStatus(SlotID slotID, ResourceProfile resourceProfile, JobID jobID, AllocationID allocationID, ResourceProfile allocationResourceProfile, List<SlotTag> tags, long version) {
        this.slotID = (SlotID)Preconditions.checkNotNull((Object)slotID, (String)"slotID cannot be null");
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile, (String)"profile cannot be null");
        this.allocationID = allocationID;
        this.jobID = jobID;
        this.allocationResourceProfile = allocationResourceProfile;
        this.tags = tags;
        this.version = version;
    }

    public SlotID getSlotID() {
        return this.slotID;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public ResourceProfile getAllocationResourceProfile() {
        return this.allocationResourceProfile;
    }

    public AllocationID getAllocationID() {
        return this.allocationID;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public List<SlotTag> getTags() {
        return this.tags;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotStatus that = (SlotStatus)o;
        if (!this.slotID.equals(that.slotID)) {
            return false;
        }
        if (!this.resourceProfile.equals(that.resourceProfile)) {
            return false;
        }
        if (this.allocationID != null ? !this.allocationID.equals((Object)that.allocationID) : that.allocationID != null) {
            return false;
        }
        if (this.allocationResourceProfile != null ? !this.allocationResourceProfile.equals(that.allocationResourceProfile) : that.allocationResourceProfile != null) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        return this.jobID != null ? this.jobID.equals((Object)that.jobID) : that.jobID == null;
    }

    public int hashCode() {
        int result = this.slotID.hashCode();
        result = 31 * result + this.resourceProfile.hashCode();
        result = 31 * result + (this.allocationID != null ? this.allocationID.hashCode() : 0);
        result = 31 * result + (this.jobID != null ? this.jobID.hashCode() : 0);
        result = 31 * result + (this.allocationResourceProfile != null ? this.allocationResourceProfile.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.version);
        return result;
    }
}

