/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public class TaskManagerConfiguration
implements TaskManagerRuntimeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerConfiguration.class);
    private final int numberSlots;
    private final String[] tmpDirectories;
    private final Time timeout;
    @Nullable
    private final Time maxRegistrationDuration;
    private final Time initialRegistrationPause;
    private final Time maxRegistrationPause;
    private final Time refusedRegistrationPause;
    private final Time maxReconnectionDuration;
    private final UnmodifiableConfiguration configuration;
    private final boolean exitJvmOnOutOfMemory;
    private final FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder;
    private final String[] alwaysParentFirstLoaderPatterns;
    @Nullable
    private final String taskManagerLogPath;
    @Nullable
    private final String taskManagerStdoutPath;
    @Nullable
    private final String taskManagerLogDir;

    public TaskManagerConfiguration(int numberSlots, String[] tmpDirectories, Time timeout, @Nullable Time maxRegistrationDuration, Time initialRegistrationPause, Time maxRegistrationPause, Time refusedRegistrationPause, Time maxReconnectionDuration, Configuration configuration, boolean exitJvmOnOutOfMemory, FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstLoaderPatterns, @Nullable String taskManagerLogPath, @Nullable String taskManagerStdoutPath, @Nullable String taskManagerLogDir) {
        this.numberSlots = numberSlots;
        this.tmpDirectories = (String[])Preconditions.checkNotNull((Object)tmpDirectories);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.maxRegistrationDuration = maxRegistrationDuration;
        this.initialRegistrationPause = (Time)Preconditions.checkNotNull((Object)initialRegistrationPause);
        this.maxRegistrationPause = (Time)Preconditions.checkNotNull((Object)maxRegistrationPause);
        this.refusedRegistrationPause = (Time)Preconditions.checkNotNull((Object)refusedRegistrationPause);
        this.maxReconnectionDuration = (Time)Preconditions.checkNotNull((Object)maxReconnectionDuration);
        this.configuration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.exitJvmOnOutOfMemory = exitJvmOnOutOfMemory;
        this.classLoaderResolveOrder = classLoaderResolveOrder;
        this.alwaysParentFirstLoaderPatterns = alwaysParentFirstLoaderPatterns;
        this.taskManagerLogPath = taskManagerLogPath;
        this.taskManagerStdoutPath = taskManagerStdoutPath;
        this.taskManagerLogDir = taskManagerLogDir;
    }

    @Override
    public int getNumberSlots() {
        return this.numberSlots;
    }

    public Time getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Time getMaxRegistrationDuration() {
        return this.maxRegistrationDuration;
    }

    public Time getInitialRegistrationPause() {
        return this.initialRegistrationPause;
    }

    @Nullable
    public Time getMaxRegistrationPause() {
        return this.maxRegistrationPause;
    }

    public Time getRefusedRegistrationPause() {
        return this.refusedRegistrationPause;
    }

    public Time getMaxReconnectionDuration() {
        return this.maxReconnectionDuration;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }

    @Override
    public boolean shouldExitJvmOnOutOfMemoryError() {
        return this.exitJvmOnOutOfMemory;
    }

    public FlinkUserCodeClassLoaders.ResolveOrder getClassLoaderResolveOrder() {
        return this.classLoaderResolveOrder;
    }

    public String[] getAlwaysParentFirstLoaderPatterns() {
        return this.alwaysParentFirstLoaderPatterns;
    }

    @Nullable
    public String getTaskManagerLogDir() {
        return this.taskManagerLogDir;
    }

    @Nullable
    public String getTaskManagerLogPath() {
        return this.taskManagerLogPath;
    }

    @Nullable
    public String getTaskManagerStdoutPath() {
        return this.taskManagerStdoutPath;
    }

    public static TaskManagerConfiguration fromConfiguration(Configuration configuration) {
        int extension;
        Time maxReconnectionDuration;
        Time refusedRegistrationPause;
        Time maxRegistrationPause;
        Time initialRegistrationPause;
        Time finiteRegistrationDuration;
        Time timeout;
        int numberSlots = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1);
        if (numberSlots == -1) {
            numberSlots = 1;
        }
        String[] tmpDirPaths = ConfigurationUtils.parseTempDirectories((Configuration)configuration);
        try {
            timeout = Time.milliseconds((long)AkkaUtils.getTimeout(configuration).toMillis());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid format for '" + AkkaOptions.ASK_TIMEOUT.key() + "'.Use formats like '50 s' or '1 min' to specify the timeout.");
        }
        LOG.info("Messages have a max timeout of " + timeout);
        try {
            Duration maxRegistrationDuration = Duration.create((String)configuration.getString(TaskManagerOptions.REGISTRATION_TIMEOUT));
            finiteRegistrationDuration = maxRegistrationDuration.isFinite() ? Time.milliseconds((long)maxRegistrationDuration.toMillis()) : null;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.REGISTRATION_TIMEOUT.key(), e);
        }
        try {
            Duration pause = Duration.create((String)configuration.getString(TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF));
            if (!pause.isFinite()) {
                throw new IllegalArgumentException("The initial registration pause must be finite: " + pause);
            }
            initialRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF.key(), e);
        }
        try {
            Duration pause = Duration.create((String)configuration.getString(TaskManagerOptions.REGISTRATION_MAX_BACKOFF));
            if (!pause.isFinite()) {
                throw new IllegalArgumentException("The maximum registration pause must be finite: " + pause);
            }
            maxRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF.key(), e);
        }
        try {
            Duration pause = Duration.create((String)configuration.getString(TaskManagerOptions.REFUSED_REGISTRATION_BACKOFF));
            if (!pause.isFinite()) {
                throw new IllegalArgumentException("The refused registration pause must be finite: " + pause);
            }
            refusedRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF.key(), e);
        }
        try {
            Duration reconnectionDuration = Duration.create((String)configuration.getString(TaskManagerOptions.RECONNECTION_TIMEOUT));
            maxReconnectionDuration = Time.milliseconds((long)reconnectionDuration.toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.RECONNECTION_TIMEOUT.key(), e);
        }
        boolean exitOnOom = configuration.getBoolean(TaskManagerOptions.KILL_ON_OUT_OF_MEMORY);
        String classLoaderResolveOrder = configuration.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((Configuration)configuration);
        String taskManagerLogPath = configuration.getString("taskmanager.log.path", System.getProperty("log.file"));
        String taskManagerStdoutPath = taskManagerLogPath != null ? ((extension = taskManagerLogPath.lastIndexOf(46)) > 0 ? taskManagerLogPath.substring(0, extension) + ".out" : null) : null;
        String taskManagerLogDir = taskManagerLogPath == null ? null : new File(taskManagerLogPath).getParent();
        return new TaskManagerConfiguration(numberSlots, tmpDirPaths, timeout, finiteRegistrationDuration, initialRegistrationPause, maxRegistrationPause, refusedRegistrationPause, maxReconnectionDuration, configuration, exitOnOom, FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns, taskManagerLogPath, taskManagerStdoutPath, taskManagerLogDir);
    }
}

